/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.fermentationvat;

import com.klikli_dev.theurgy.content.apparatus.fermentationvat.FermentationCachedCheck;
import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.FermentationRecipe;
import com.klikli_dev.theurgy.content.recipe.wrapper.RecipeWrapperWithFluid;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class FermentationCraftingBehaviour
extends CraftingBehaviour<RecipeWrapperWithFluid, FermentationRecipe, FermentationCachedCheck> {
    protected Supplier<IFluidHandler> fluidTankSupplier;

    public FermentationCraftingBehaviour(BlockEntity blockEntity, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<IFluidHandler> fluidTankSupplier) {
        super(blockEntity, Lazy.of(() -> new RecipeWrapperWithFluid((IItemHandlerModifiable)inputInventorySupplier.get(), (IFluidHandler)fluidTankSupplier.get())), inputInventorySupplier, outputInventorySupplier, new FermentationCachedCheck((RecipeType<FermentationRecipe>)((RecipeType)RecipeTypeRegistry.FERMENTATION.get())));
        this.fluidTankSupplier = fluidTankSupplier;
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(0))) {
            return true;
        }
        return ((FermentationCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.m_58904_()).isPresent();
    }

    public boolean canProcess(FluidStack stack) {
        if (this.fluidTankSupplier.get().getFluidInTank(0).isFluidEqual(stack)) {
            return true;
        }
        return ((FermentationCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.m_58904_()).isPresent();
    }

    @Override
    protected int getIngredientCount(FermentationRecipe recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(FermentationRecipe recipe) {
        return recipe.getTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 200;
    }

    @Override
    protected boolean craft(FermentationRecipe pRecipe) {
        ItemStack assembledStack = pRecipe.assemble((RecipeWrapperWithFluid)((Object)this.recipeWrapperSupplier.get()), this.blockEntity.m_58904_().m_9598_());
        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)false);
        block0: for (Ingredient ingredient : pRecipe.m_7527_()) {
            for (int i = 0; i < ((IItemHandlerModifiable)this.inputInventorySupplier.get()).getSlots(); ++i) {
                if (!ingredient.test(((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(i))) continue;
                ((IItemHandlerModifiable)this.inputInventorySupplier.get()).extractItem(i, this.getIngredientCount(pRecipe), false);
                continue block0;
            }
        }
        this.fluidTankSupplier.get().drain(pRecipe.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
        return true;
    }
}

