/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.incubator;

import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.IncubationRecipe;
import com.klikli_dev.theurgy.content.recipe.wrapper.IncubatorRecipeWrapper;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class IncubatorCraftingBehaviour
extends CraftingBehaviour<IncubatorRecipeWrapper, IncubationRecipe, RecipeManager.CachedCheck<IncubatorRecipeWrapper, IncubationRecipe>> {
    public IncubatorCraftingBehaviour(BlockEntity blockEntity, Supplier<IncubatorRecipeWrapper> recipeWrapperSupplier, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier) {
        super(blockEntity, recipeWrapperSupplier, inputInventorySupplier, outputInventorySupplier, RecipeManager.m_220267_((RecipeType)((RecipeType)RecipeTypeRegistry.INCUBATION.get())));
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        return true;
    }

    @Override
    protected boolean craft(IncubationRecipe pRecipe) {
        IncubatorRecipeWrapper recipeWrapper = (IncubatorRecipeWrapper)((Object)this.recipeWrapperSupplier.get());
        ItemStack assembledStack = pRecipe.assemble(recipeWrapper, this.blockEntity.m_58904_().m_9598_());
        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)false);
        recipeWrapper.getMercuryVesselInv().extractItem(0, 1, false);
        recipeWrapper.getSaltVesselInv().extractItem(0, 1, false);
        recipeWrapper.getSulfurVesselInv().extractItem(0, 1, false);
        return true;
    }

    @Override
    protected int getIngredientCount(IncubationRecipe recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(IncubationRecipe recipe) {
        return recipe.getIncubationTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 100;
    }

    @Override
    protected int getTotalTime() {
        return this.recipeWrapperSupplier.get() != null ? super.getTotalTime() : this.getDefaultCraftingTime();
    }
}

