/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.fluidhandler;

import com.klikli_dev.theurgy.content.behaviour.fluidhandler.FluidHandlerBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class OneTankFluidHandlerBehaviour
implements FluidHandlerBehaviour {
    @Override
    public InteractionResult useFluidHandler(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        FluidStack transferredFluid;
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        ItemStack stackInHand = pPlayer.m_21120_(pHand);
        ItemStack fillStack = stackInHand.m_255036_(1);
        LazyOptional blockFluidHandlerCap = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER);
        LazyOptional itemFluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)fillStack);
        if (!blockFluidHandlerCap.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandler blockFluidHandler = (IFluidHandler)blockFluidHandlerCap.orElse(null);
        if (stackInHand.m_41619_() && pPlayer.m_6144_()) {
            blockFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            return InteractionResult.SUCCESS;
        }
        if (!itemFluidHandlerCap.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandlerItem itemFluidHandler = (IFluidHandlerItem)itemFluidHandlerCap.orElse(null);
        if (this.updateFluidContainerInHand(pPlayer, pHand, stackInHand, itemFluidHandler, transferredFluid = FluidUtil.tryFluidTransfer((IFluidHandler)blockFluidHandler, (IFluidHandler)itemFluidHandler, (int)Integer.MAX_VALUE, (boolean)true))) {
            return InteractionResult.SUCCESS;
        }
        transferredFluid = FluidUtil.tryFluidTransfer((IFluidHandler)itemFluidHandler, (IFluidHandler)blockFluidHandler, (int)Integer.MAX_VALUE, (boolean)true);
        if (this.updateFluidContainerInHand(pPlayer, pHand, stackInHand, itemFluidHandler, transferredFluid)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean updateFluidContainerInHand(Player pPlayer, InteractionHand pHand, ItemStack stackInHand, IFluidHandlerItem itemFluidHandler, FluidStack transferredFluid) {
        if (!transferredFluid.isEmpty()) {
            stackInHand.m_41774_(1);
            if (stackInHand.m_41619_()) {
                pPlayer.m_21008_(pHand, itemFluidHandler.getContainer());
            } else {
                pPlayer.m_21008_(pHand, stackInHand);
                pPlayer.m_150109_().m_150079_(itemFluidHandler.getContainer());
            }
            return true;
        }
        return false;
    }
}

