/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.selection;

import com.klikli_dev.theurgy.content.behaviour.selection.SelectedPoint;
import com.klikli_dev.theurgy.content.render.outliner.Outliner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SelectionBehaviour<T extends SelectedPoint> {
    protected List<T> selectedPoints = new ArrayList<T>();
    protected ItemStack currentItem;

    public boolean onRightClickBlock(Level level, Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        if (this.currentItem == null || player == null) {
            return false;
        }
        if (!level.f_46443_) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        T selected = this.get(pos);
        BlockState state = level.m_8055_(pos);
        if (selected == null) {
            T point = this.create(level, pos, state);
            if (point == null) {
                return false;
            }
            selected = point;
            this.add(point);
        } else if (!((SelectedPoint)selected).cycleMode()) {
            this.remove(pos);
            return true;
        }
        player.m_5661_(this.getModeMessage(selected, state), true);
        return true;
    }

    public boolean onLeftClickBlock(Level level, Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        if (this.currentItem == null) {
            return false;
        }
        if (!level.f_46443_) {
            return false;
        }
        return this.remove(pos) != null;
    }

    public void onPlace(BlockPos pos, Player player) {
        int removed = 0;
        Iterator<T> iterator = this.selectedPoints.iterator();
        while (iterator.hasNext()) {
            SelectedPoint point = (SelectedPoint)iterator.next();
            if (point.getBlockPos().m_123314_((Vec3i)pos, (double)this.getBlockRange())) continue;
            iterator.remove();
            ++removed;
        }
        if (removed > 0) {
            player.m_5661_(this.getOutsideRangeMessage(removed), true);
        } else {
            this.displaySummary(pos, player);
        }
        this.sendPlacementPacket(pos);
        this.selectedPoints.clear();
        this.currentItem = null;
    }

    public void tick(Player player) {
        ItemStack heldItem = player.m_21205_();
        if (!this.isSelectionItem(heldItem)) {
            this.currentItem = null;
        } else {
            if (heldItem != this.currentItem) {
                this.selectedPoints.clear();
                this.currentItem = heldItem;
            }
            this.prepareRender();
        }
    }

    protected void prepareRender() {
        Iterator<T> iterator = this.selectedPoints.iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            SelectedPoint point = (SelectedPoint)iterator.next();
            if (!this.isValid(point)) {
                iterator.remove();
                continue;
            }
            Level level = point.getLevel();
            BlockState state = level.m_8055_(pos = point.getBlockPos());
            VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
            if (shape.m_83281_()) continue;
            int color = point.getColor().getRGB();
            Outliner.get().showAABB(point, shape.m_83215_().m_82338_(pos)).colored(color).lineWidth(0.0625f);
        }
    }

    protected void add(T point) {
        this.selectedPoints.add(point);
    }

    protected T remove(BlockPos pos) {
        T result = this.get(pos);
        if (result != null) {
            this.selectedPoints.remove(result);
        }
        return result;
    }

    protected T get(BlockPos pos) {
        for (SelectedPoint point : this.selectedPoints) {
            if (!point.getBlockPos().equals((Object)pos)) continue;
            return (T)point;
        }
        return null;
    }

    public boolean isValid(T point) {
        ((SelectedPoint)point).refreshBlockStateCache();
        return this.canCreate(((SelectedPoint)point).getLevel(), ((SelectedPoint)point).getBlockPos(), ((SelectedPoint)point).getBlockState());
    }

    protected Component getModeMessage(T point, BlockState state) {
        return Component.m_237110_((String)"theurgy.behaviour.selection.mode", (Object[])new Object[]{((SelectedPoint)point).getModeMessage(), state.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE)}).m_130938_(s -> s.m_178520_(point.getColor().getRGB()));
    }

    protected Component getOutsideRangeMessage(int removed) {
        return Component.m_237110_((String)"theurgy.behaviour.selection.outside_range", (Object[])new Object[]{removed}).m_130940_(ChatFormatting.RED);
    }

    protected abstract void displaySummary(BlockPos var1, Player var2);

    protected abstract void sendPlacementPacket(BlockPos var1);

    public abstract int getBlockRange();

    public abstract boolean canCreate(Level var1, BlockPos var2, BlockState var3);

    protected abstract T create(Level var1, BlockPos var2, BlockState var3);

    protected abstract boolean isSelectionItem(ItemStack var1);
}

