/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.entity;

import com.klikli_dev.theurgy.content.entity.ColoredProjectile;
import com.klikli_dev.theurgy.content.particle.ParticleColor;
import com.klikli_dev.theurgy.content.particle.glow.GlowParticleProvider;
import com.klikli_dev.theurgy.content.render.Color;
import com.klikli_dev.theurgy.registry.EntityDataSerializerRegistry;
import com.klikli_dev.theurgy.registry.EntityRegistry;
import com.klikli_dev.theurgy.registry.ParticleRegistry;
import com.mojang.serialization.DynamicOps;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.Nullable;

public class FollowProjectile
extends ColoredProjectile {
    public static final EntityDataAccessor<Vec3> TO = SynchedEntityData.m_135353_(FollowProjectile.class, (EntityDataSerializer)((EntityDataSerializer)EntityDataSerializerRegistry.VEC3_FLOAT.get()));
    public static final EntityDataAccessor<Vec3> FROM = SynchedEntityData.m_135353_(FollowProjectile.class, (EntityDataSerializer)((EntityDataSerializer)EntityDataSerializerRegistry.VEC3_FLOAT.get()));
    public static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(FollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> SPAWN_TOUCH = SynchedEntityData.m_135353_(FollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DESPAWN_DISTANCE = SynchedEntityData.m_135353_(FollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> ARRIVAL_DISTANCE = SynchedEntityData.m_135353_(FollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int maxAge = 500;
    private int age;
    private long spawnTime = -1L;
    private Consumer<FollowProjectile> onArrival;

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, @Nullable Color finalColor, float size, float arrivalDistance, Consumer<FollowProjectile> onArrival) {
        this((EntityType<? extends FollowProjectile>)((EntityType)EntityRegistry.FOLLOW_PROJECTILE.get()), level);
        this.f_19804_.m_135381_(TO, (Object)to);
        this.f_19804_.m_135381_(FROM, (Object)from);
        this.m_6034_(from.f_82479_, from.f_82480_, from.f_82481_);
        this.f_19804_.m_135381_(COLOR, (Object)color.getRGB());
        this.f_19804_.m_135381_(FINAL_COLOR, (Object)(finalColor == null ? color.getRGB() : finalColor.getRGB()));
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
        this.f_19804_.m_135381_(ARRIVAL_DISTANCE, (Object)Float.valueOf(arrivalDistance));
        double distance = from.m_82554_(to);
        this.onArrival = onArrival;
        this.setDespawnDistance((int)(distance + 10.0));
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, @Nullable Color finalColor, float size, Consumer<FollowProjectile> onArrival) {
        this(level, from, to, color, finalColor, size, 1.0f, onArrival);
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, int r, int g, int b, float size) {
        this(level, from, to, new Color(r, g, b), new Color(r, g, b), size, 1.0f, p -> {});
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, int r, int g, int b, float size, float arrivalDistance) {
        this(level, from, to, new Color(r, g, b), new Color(r, g, b), size, arrivalDistance, p -> {});
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, float size, Consumer<FollowProjectile> onArrival) {
        this(level, from, to, color, color, size, 1.0f, onArrival);
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, float size, float arrivalDistance, Consumer<FollowProjectile> onArrival) {
        this(level, from, to, color, color, size, arrivalDistance, onArrival);
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, float size) {
        this(level, from, to, color, size, p -> {});
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, float size, float arrivalDistance) {
        this(level, from, to, color, size, arrivalDistance, (FollowProjectile p) -> {});
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, Color finalColor, float size) {
        this(level, from, to, color, finalColor, size, 1.0f, p -> {});
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, Color finalColor, float size, float arrivalDistance) {
        this(level, from, to, color, finalColor, size, arrivalDistance, p -> {});
    }

    public FollowProjectile(EntityType<? extends FollowProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public FollowProjectile(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends ColoredProjectile>)((EntityType)EntityRegistry.FOLLOW_PROJECTILE.get()), world);
    }

    public void setDespawnDistance(int distance) {
        this.m_20088_().m_135381_(DESPAWN_DISTANCE, (Object)distance);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TO, (Object)new Vec3(0.0, 0.0, 0.0));
        this.f_19804_.m_135372_(FROM, (Object)new Vec3(0.0, 0.0, 0.0));
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SPAWN_TOUCH, (Object)this.defaultsBurst());
        this.f_19804_.m_135372_(DESPAWN_DISTANCE, (Object)10);
        this.f_19804_.m_135372_(ARRIVAL_DISTANCE, (Object)Float.valueOf(1.0f));
    }

    public boolean defaultsBurst() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.age;
        if (this.age > this.maxAge || this.m_9236_().m_46467_() - this.spawnTime > (long)this.maxAge) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        Vec3 deltaMovement = this.m_20184_();
        Vec3 to = (Vec3)this.f_19804_.m_135370_(TO);
        Vec3 from = (Vec3)this.f_19804_.m_135370_(FROM);
        double totalDist = from.m_82554_(to);
        double coveredDist = this.m_20182_().m_82554_(from);
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        double motionX = deltaMovement.f_82479_;
        double motionY = deltaMovement.f_82480_;
        double motionZ = deltaMovement.f_82481_;
        double maxMotion = Math.max(Math.abs(motionX), Math.max(Math.abs(motionY), Math.abs(motionZ)));
        double arrivalDistance = ((Float)this.f_19804_.m_135370_(ARRIVAL_DISTANCE)).floatValue();
        if (Math.sqrt(this.m_20182_().m_82557_(to)) < arrivalDistance || maxMotion >= arrivalDistance && maxMotion + Math.sqrt(this.m_20182_().m_82557_(to)) < arrivalDistance || this.age > 1000 || Math.sqrt(this.m_20182_().m_82557_(to)) > (double)((Integer)this.f_19804_.m_135370_(DESPAWN_DISTANCE)).intValue()) {
            if (this.m_9236_().f_46443_ && ((Boolean)this.f_19804_.m_135370_(SPAWN_TOUCH)).booleanValue()) {
                ParticleRegistry.spawnTouch((ClientLevel)this.m_9236_(), this.m_20097_(), ParticleColor.fromInt(this.finalColor()));
            }
            this.onArrival.accept(this);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (to.m_7096_() != 0.0 || to.m_7098_() != 0.0 || to.m_7094_() != 0.0) {
            double targetX = to.m_7096_();
            double targetY = to.m_7098_();
            double targetZ = to.m_7094_();
            Vec3 targetVector = new Vec3(targetX - posX, targetY - posY, targetZ - posZ);
            double length = targetVector.m_82553_();
            targetVector = targetVector.m_82490_(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = 0.9 * ((3.0 - length) / 3.0);
            }
            motionX = (0.9 - weight) * motionX + (0.1 + weight) * targetVector.f_82479_;
            motionY = (0.9 - weight) * motionY + (0.1 + weight) * targetVector.f_82480_;
            motionZ = (0.9 - weight) * motionZ + (0.1 + weight) * targetVector.f_82481_;
        }
        this.m_6034_(posX += motionX, posY += motionY, posZ += motionZ);
        this.m_20334_(motionX, motionY, motionZ);
        float speed = 1.0f;
        this.m_20256_(this.m_20184_().m_82490_((double)speed));
        if (this.m_9236_().f_46443_ && this.age > 1) {
            int endColor;
            int particleAge = 50;
            double deltaX = this.m_20185_() - this.f_19790_;
            double deltaY = this.m_20186_() - this.f_19791_;
            double deltaZ = this.m_20189_() - this.f_19792_;
            float dist = (float)(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 8.0);
            int startColor = this.color();
            int currentColor = startColor == (endColor = this.finalColor()) ? endColor : Color.mixColors(startColor, endColor, (float)(coveredDist / totalDist));
            for (double i = 0.0; i <= (double)dist; i += 1.0) {
                double coeff = i / (double)dist;
                this.m_9236_().m_7106_(GlowParticleProvider.createOptions(ParticleColor.fromInt(currentColor), ((Float)this.f_19804_.m_135370_(SIZE)).floatValue(), 0.75f, particleAge), this.m_20185_() + deltaX * coeff, this.m_20186_() + deltaY * coeff, this.m_20189_() + deltaZ * coeff, (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)));
            }
        }
    }

    public void m_142467_(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.UNLOADED_TO_CHUNK) {
            reason = Entity.RemovalReason.DISCARDED;
        }
        super.m_142467_(reason);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(FROM, (Object)((Vec3)Vec3.f_231074_.parse((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("from")).result().get()));
        this.f_19804_.m_135381_(TO, (Object)((Vec3)Vec3.f_231074_.parse((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("to")).result().get()));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        Vec3.f_231074_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((Vec3)this.f_19804_.m_135370_(FROM))).result().ifPresent(e -> compound.m_128365_("from", e));
        Vec3.f_231074_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((Vec3)this.f_19804_.m_135370_(TO))).result().ifPresent(e -> compound.m_128365_("to", e));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        throw new UnsupportedOperationException();
    }

    public EntityType<?> m_6095_() {
        return (EntityType)EntityRegistry.FOLLOW_PROJECTILE.get();
    }

    public boolean m_20068_() {
        return true;
    }

    public Vec3 to() {
        return (Vec3)this.f_19804_.m_135370_(TO);
    }

    public Vec3 from() {
        return (Vec3)this.f_19804_.m_135370_(FROM);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.spawnTime = this.m_9236_().m_46467_();
    }
}

