/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.particle.glow;

import com.klikli_dev.theurgy.content.particle.ParticleColor;
import com.klikli_dev.theurgy.registry.ParticleRegistry;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class GlowParticleOptions
implements ParticleOptions {
    public static final Codec<GlowParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color.getBlue())), (App)Codec.BOOL.fieldOf("disableDepthTest").forGetter(d -> d.disableDepthTest), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.FLOAT.fieldOf("alpha").forGetter(d -> Float.valueOf(d.alpha)), (App)Codec.INT.fieldOf("age").forGetter(d -> d.age)).apply((Applicative)instance, GlowParticleOptions::new));
    public static final ParticleOptions.Deserializer<GlowParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<GlowParticleOptions>(){

        public GlowParticleOptions fromCommand(ParticleType<GlowParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new GlowParticleOptions(type, ParticleColor.fromString(reader.readString()), reader.readBoolean());
        }

        public GlowParticleOptions fromNetwork(ParticleType<GlowParticleOptions> type, FriendlyByteBuf buffer) {
            return new GlowParticleOptions(type, ParticleColor.deserialize(buffer.m_130260_()), buffer.readBoolean());
        }
    };
    private final ParticleType<GlowParticleOptions> type;
    public ParticleColor color;
    public boolean disableDepthTest;
    public float size = 0.25f;
    public float alpha = 1.0f;
    public int age = 36;

    public GlowParticleOptions(float r, float g, float b, boolean disableDepthTest, float size, float alpha, int age) {
        this((ParticleType<GlowParticleOptions>)((ParticleType)ParticleRegistry.GLOW_TYPE.get()), new ParticleColor(r, g, b), disableDepthTest, size, alpha, age);
    }

    public GlowParticleOptions(ParticleColor color, boolean disableDepthTest, float size, float alpha, int age) {
        this((ParticleType<GlowParticleOptions>)((ParticleType)ParticleRegistry.GLOW_TYPE.get()), color, disableDepthTest, size, alpha, age);
    }

    public GlowParticleOptions(ParticleType<GlowParticleOptions> particleTypeData, ParticleColor color, boolean disableDepthTest) {
        this(particleTypeData, color, disableDepthTest, 0.25f, 1.0f, 36);
    }

    public GlowParticleOptions(ParticleType<GlowParticleOptions> particleTypeData, ParticleColor color, boolean disableDepthTest, float size, float alpha, int age) {
        this.type = particleTypeData;
        this.color = color;
        this.disableDepthTest = disableDepthTest;
        this.size = size;
        this.alpha = alpha;
        this.age = age;
    }

    public ParticleType<GlowParticleOptions> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130079_(this.color.serialize());
    }

    public String m_5942_() {
        return String.valueOf(ForgeRegistries.PARTICLE_TYPES.getKey(this.type)) + " " + String.valueOf(this.color.serialize());
    }
}

