/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.render.outliner;

import com.klikli_dev.theurgy.content.render.outliner.AABBOutline;
import com.klikli_dev.theurgy.content.render.outliner.ChasingAABBOutline;
import com.klikli_dev.theurgy.content.render.outliner.Outline;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Outliner {
    private static final Outliner instance = new Outliner();
    private final Map<Object, OutlineEntry> outlines = Collections.synchronizedMap(new HashMap());
    private final Map<Object, OutlineEntry> outlinesView = Collections.unmodifiableMap(this.outlines);

    public static Outliner get() {
        return instance;
    }

    public Outline.OutlineParams showAABB(Object slot, AABB bb, int ttl) {
        this.createAABBOutlineIfMissing(slot, bb);
        ChasingAABBOutline outline = this.getAndRefreshAABB(slot, ttl);
        outline.targetBB = outline.bb = bb;
        outline.prevBB = outline.bb;
        return outline.getParams();
    }

    public Outline.OutlineParams showAABB(Object slot, AABB bb) {
        this.createAABBOutlineIfMissing(slot, bb);
        ChasingAABBOutline outline = this.getAndRefreshAABB(slot);
        outline.targetBB = outline.bb = bb;
        outline.prevBB = outline.bb;
        return outline.getParams();
    }

    public Outline.OutlineParams chaseAABB(Object slot, AABB bb) {
        this.createAABBOutlineIfMissing(slot, bb);
        ChasingAABBOutline outline = this.getAndRefreshAABB(slot);
        outline.targetBB = bb;
        return outline.getParams();
    }

    public void keep(Object slot) {
        if (this.outlines.containsKey(slot)) {
            this.outlines.get((Object)slot).ticksTillRemoval = 1;
        }
    }

    public void remove(Object slot) {
        this.outlines.remove(slot);
    }

    public Optional<Outline.OutlineParams> edit(Object slot) {
        this.keep(slot);
        if (this.outlines.containsKey(slot)) {
            return Optional.of(this.outlines.get(slot).getOutline().getParams());
        }
        return Optional.empty();
    }

    public Map<Object, OutlineEntry> getOutlines() {
        return this.outlinesView;
    }

    private void addOutline(Object slot, Outline outline) {
        this.outlines.put(slot, new OutlineEntry(outline));
    }

    private void createAABBOutlineIfMissing(Object slot, AABB bb) {
        if (!this.outlines.containsKey(slot) || !(this.outlines.get((Object)slot).outline instanceof AABBOutline)) {
            ChasingAABBOutline outline = new ChasingAABBOutline(bb);
            this.addOutline(slot, outline);
        }
    }

    private ChasingAABBOutline getAndRefreshAABB(Object slot) {
        return this.getAndRefreshAABB(slot, 1);
    }

    private ChasingAABBOutline getAndRefreshAABB(Object slot, int ttl) {
        OutlineEntry entry = this.outlines.get(slot);
        entry.ticksTillRemoval = ttl;
        return (ChasingAABBOutline)entry.getOutline();
    }

    public void tick() {
        Iterator<OutlineEntry> iterator = this.outlines.values().iterator();
        while (iterator.hasNext()) {
            OutlineEntry entry = iterator.next();
            entry.tick();
            if (entry.isAlive()) continue;
            iterator.remove();
        }
    }

    public void render(PoseStack ms, MultiBufferSource.BufferSource buffer, Vec3 camera, float pt) {
        this.outlines.forEach((key, entry) -> {
            Outline outline = entry.getOutline();
            Outline.OutlineParams params = outline.getParams();
            params.alpha = 1.0f;
            if (entry.isFading()) {
                int prevTicks = entry.ticksTillRemoval + 1;
                float fadeticks = 8.0f;
                float lastAlpha = prevTicks >= 0 ? 1.0f : 1.0f + (float)prevTicks / fadeticks;
                float currentAlpha = 1.0f + (float)entry.ticksTillRemoval / fadeticks;
                float alpha = Mth.m_14179_((float)pt, (float)lastAlpha, (float)currentAlpha);
                params.alpha = alpha * alpha * alpha;
                if (params.alpha < 0.125f) {
                    return;
                }
            }
            outline.render(ms, buffer, camera, pt);
        });
    }

    public static class OutlineEntry {
        public static final int FADE_TICKS = 8;
        private final Outline outline;
        private int ticksTillRemoval = 1;

        public OutlineEntry(Outline outline) {
            this.outline = outline;
        }

        public Outline getOutline() {
            return this.outline;
        }

        public int getTicksTillRemoval() {
            return this.ticksTillRemoval;
        }

        public boolean isAlive() {
            return this.ticksTillRemoval >= -8;
        }

        public boolean isFading() {
            return this.ticksTillRemoval < 0;
        }

        public void tick() {
            --this.ticksTillRemoval;
            this.outline.tick();
        }
    }
}

