/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.FluidRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class AccumulationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public AccumulationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "accumulation");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        Fluid salAmmoniac = (Fluid)FluidRegistry.SAL_AMMONIAC.get();
        this.makeRecipe("sal_ammoniac_from_water", salAmmoniac, 100, (Item)null, (TagKey<Fluid>)FluidTags.f_13131_, 1000, 100);
        this.makeRecipe("sal_ammoniac_from_water_and_sal_ammoniac_crystal", salAmmoniac, 1000, ItemTagRegistry.GEMS_SAL_AMMONIAC, (TagKey<Fluid>)FluidTags.f_13131_, 1000, 100);
    }

    public void makeRecipe(String name, Fluid result, int resultAmount, @Nullable Item solute, TagKey<Fluid> evaporant, int evaporantAmount, int accumulationTime) {
        this.recipeConsumer.accept(this.modLoc(name), this.makeRecipeJson(this.makeFluidTagIngredient(evaporant.f_203868_()), evaporantAmount, solute != null ? this.makeItemIngredient(this.locFor((ItemLike)solute)) : null, this.makeFluidResult(new FluidStack(result, resultAmount)), accumulationTime));
    }

    public void makeRecipe(String name, Fluid result, int resultAmount, @Nullable TagKey<Item> solute, TagKey<Fluid> evaporant, int evaporantAmount, int accumulationTime) {
        this.recipeConsumer.accept(this.modLoc(name), this.makeRecipeJson(this.makeFluidTagIngredient(evaporant.f_203868_()), evaporantAmount, solute != null ? this.makeTagIngredient(solute.f_203868_()) : null, this.makeFluidResult(new FluidStack(result, resultAmount)), accumulationTime));
    }

    public JsonObject makeRecipeJson(JsonObject evaporant, int evaporantAmount, @Nullable JsonObject solute, JsonObject result, int accumulationTime) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", RecipeTypeRegistry.ACCUMULATION.getId().toString());
        recipe.add("evaporant", (JsonElement)evaporant);
        recipe.addProperty("evaporantAmount", (Number)evaporantAmount);
        if (solute != null) {
            recipe.add("solute", (JsonElement)solute);
        }
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("accumulationTime", (Number)accumulationTime);
        return recipe;
    }

    public String m_6055_() {
        return "Accumulation Recipes";
    }
}

