/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.recipe.CatalysationRecipe;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;

public class CatalysationRecipeProvider
extends JsonRecipeProvider {
    public static final int PER_TICK = 20;

    public CatalysationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "catalysation");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipe("mercury_flux_from_mercury_shard", Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MERCURY_SHARD.get()}), 800, 20);
    }

    public void makeRecipe(String name, Ingredient ingredient, int totalMercuryFlux, int mercuryFluxPerTick) {
        this.recipeConsumer.accept(this.modLoc(name), this.makeRecipeJson(ingredient, totalMercuryFlux, mercuryFluxPerTick));
    }

    public JsonObject makeRecipeJson(Ingredient ingredient, int totalMercuryFlux, int mercuryFluxPerTick) {
        CatalysationRecipe recipe = new CatalysationRecipe(ingredient, totalMercuryFlux, mercuryFluxPerTick);
        JsonObject json = ((JsonElement)CatalysationRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).resultOrPartial(arg_0 -> ((Logger)Theurgy.LOGGER).error(arg_0)).get()).getAsJsonObject();
        json.addProperty("type", "theurgy:catalysation");
        return json;
    }

    public String m_6055_() {
        return "Catalysation Recipes";
    }
}

