/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.item.AlchemicalSaltItem;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SaltRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class IncubationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public IncubationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "incubation");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipe(Items.f_42405_, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.CROPS.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.WHEAT.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.INGOTS_IRON, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.IRON.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.INGOTS_COPPER, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.COPPER.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.INGOTS_GOLD, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.GOLD.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.INGOTS_NETHERITE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.NETHERITE.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_URANIUM, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.URANIUM.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_SILVER, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.SILVER.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_AZURE_SILVER, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.AZURE_SILVER.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_ZINC, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.ZINC.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_OSMIUM, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.OSMIUM.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_NICKEL, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.NICKEL.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_LEAD, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.LEAD.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_ALLTHEMODIUM, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.ALLTHEMODIUM.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_UNOBTAINIUM, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.UNOBTAINIUM.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_IRIDIUM, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.IRIDIUM.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_TIN, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.TIN.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_CINNABAR, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.CINNABAR.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_CRIMSON_IRON, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.CRIMSON_IRON.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_PLATINUM, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.PLATINUM.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_VIBRANIUM, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.VIBRANIUM.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_DESH, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.DESH.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_OSTRUM, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.OSTRUM.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_CALORITE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.CALORITE.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_IESNIUM, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.IESNIUM.get()));
        this.makeRecipe(ItemTagRegistry.INGOTS_DEMONITE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.DEMONITE.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.GEMS_DIAMOND, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.DIAMOND.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.GEMS_EMERALD, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.EMERALD.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.GEMS_LAPIS, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.LAPIS.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.GEMS_QUARTZ, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.QUARTZ.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.GEMS_AMETHYST, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.AMETHYST.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.GEMS_PRISMARINE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.PRISMARINE.get()));
        this.makeRecipe(ItemTagRegistry.GEMS_RUBY, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.RUBY.get()));
        this.makeRecipe(ItemTagRegistry.GEMS_APATITE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.APATITE.get()));
        this.makeRecipe(ItemTagRegistry.GEMS_PERIDOT, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.PERIDOT.get()));
        this.makeRecipe(ItemTagRegistry.GEMS_FLUORITE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.FLUORITE.get()));
        this.makeRecipe(ItemTagRegistry.GEMS_SAPPHIRE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.SAPPHIRE.get()));
        this.makeRecipe(ItemTagRegistry.GEMS_SAL_AMMONIAC, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.SAL_AMMONIAC.get()));
        this.makeRecipe(ItemTagRegistry.GEMS_CERTUS_QUARTZ, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.CERTUS_QUARTZ.get()));
        this.makeRecipe(ItemTagRegistry.GEMS_FLUIX, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.FLUIX.get()));
        this.makeRecipe(ItemTagRegistry.GEMS_NITER, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.NITER.get()));
        this.makeRecipe(ItemTagRegistry.GEMS_CHIMERITE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.CHIMERITE.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.DUSTS_REDSTONE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.REDSTONE.get()));
        this.makeRecipe((TagKey<Item>)ItemTags.f_13160_, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.COAL.get()));
        this.makeRecipe(this.tag("forge:gems/sulfur"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.SULFUR.get()));
    }

    public void makeRecipe(TagKey<Item> result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur) {
        this.makeRecipe(result, 1, mercury, salt, sulfur, 100);
    }

    public void makeRecipe(TagKey<Item> result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(result, 1, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(TagKey<Item> result, int resultCount, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(this.name(result) + "_from_" + this.name(sulfur), result, resultCount, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(String recipeName, TagKey<Item> result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(recipeName, result, 1, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(String recipeName, TagKey<Item> result, int resultCount, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        JsonObject recipe = this.makeRecipeJson(this.makeItemIngredient(this.locFor((ItemLike)mercury)), this.makeItemIngredient(this.locFor((ItemLike)salt)), this.makeItemIngredient(this.locFor((ItemLike)sulfur)), this.makeTagResult(this.locFor(result), resultCount), incubationTime);
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)this.makeTagNotEmptyCondition(result.f_203868_().toString()));
        recipe.add("conditions", (JsonElement)conditions);
        this.recipeConsumer.accept(this.modLoc(recipeName), recipe);
    }

    public void makeRecipe(Item result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur) {
        this.makeRecipe(result, 1, mercury, salt, sulfur, 100);
    }

    public void makeRecipe(Item result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(result, 1, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(Item result, int resultCount, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(this.name(result), result, resultCount, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(String recipeName, Item result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(recipeName, result, 1, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(String recipeName, Item result, int resultCount, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.recipeConsumer.accept(this.modLoc(recipeName), this.makeRecipeJson(this.makeItemIngredient(this.locFor((ItemLike)mercury)), this.makeItemIngredient(this.locFor((ItemLike)salt)), this.makeItemIngredient(this.locFor((ItemLike)sulfur)), this.makeItemResult(this.locFor((ItemLike)result), resultCount), incubationTime));
    }

    public JsonObject makeRecipeJson(JsonObject mercury, JsonObject salt, JsonObject sulfur, JsonObject result, int incubationTime) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", RecipeTypeRegistry.INCUBATION.getId().toString());
        recipe.add("mercury", (JsonElement)mercury);
        recipe.add("salt", (JsonElement)salt);
        recipe.add("sulfur", (JsonElement)sulfur);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("incubation_time", (Number)incubationTime);
        return recipe;
    }

    public String m_6055_() {
        return "Incubation Recipes";
    }
}

