/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.amendments.common.network.ClientBoundFireballExplodePacket;
import net.mehvahdjukaar.amendments.common.network.ModNetwork;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FireballExplosion
extends Explosion {
    private final float maxDamage;
    private final boolean hasKnockback;
    private final int onFireTicks;
    private final float soundVolume;
    private final Set<BlockPos> visitedBlock = new HashSet<BlockPos>();

    public static FireballExplosion explodeServer(Level serverLevel, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction) {
        return FireballExplosion.explodeServer(serverLevel, source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, new ExtraSettings());
    }

    public static FireballExplosion explodeServer(Level serverLevel, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, ExtraSettings settings) {
        FireballExplosion explosion = FireballExplosion.explode(serverLevel, source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, false, settings);
        if (!(serverLevel instanceof ServerLevel)) {
            return explosion;
        }
        ServerLevel sl = (ServerLevel)serverLevel;
        if (!explosion.m_254884_()) {
            explosion.m_46080_();
        }
        for (ServerPlayer serverPlayer : sl.m_6907_()) {
            if (!(serverPlayer.m_20275_(x, y, z) < 4096.0)) continue;
            ModNetwork.CHANNEL.sendToClientPlayer(serverPlayer, (Message)new ClientBoundFireballExplodePacket(x, y, z, radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverPlayer), explosion.soundVolume));
        }
        return explosion;
    }

    public static FireballExplosion explode(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, boolean spawnParticles, ExtraSettings settings) {
        Explosion.BlockInteraction blockInteraction = switch (explosionInteraction) {
            default -> throw new IncompatibleClassChangeError();
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> level.m_255157_(GameRules.f_254629_);
            case Level.ExplosionInteraction.MOB -> {
                if (level.m_46469_().m_46207_(GameRules.f_46132_)) {
                    yield level.m_255157_(GameRules.f_254692_);
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case Level.ExplosionInteraction.TNT -> level.m_255157_(GameRules.f_254705_);
        };
        FireballExplosion explosion = new FireballExplosion(level, source, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction, settings);
        explosion.m_46061_();
        explosion.m_46075_(spawnParticles);
        return explosion;
    }

    public FireballExplosion(Level level, @Nullable Entity source, double toBlowX, double toBlowY, double toBlowZ, float radius, List<BlockPos> positions, ExtraSettings settings) {
        super(level, source, toBlowX, toBlowY, toBlowZ, radius, positions);
        this.onFireTicks = settings.onFireTicks;
        this.maxDamage = settings.maxDamage;
        this.hasKnockback = settings.hasKnockback;
        this.soundVolume = settings.soundVolume;
    }

    public FireballExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, Explosion.BlockInteraction blockInteraction, ExtraSettings settings) {
        super(level, source, damageSource, damageCalculator, toBlowX, toBlowY, toBlowZ, radius, fire, blockInteraction);
        this.onFireTicks = settings.onFireTicks;
        this.maxDamage = settings.maxDamage;
        this.hasKnockback = settings.hasKnockback;
        this.soundVolume = settings.soundVolume;
    }

    public void m_46061_() {
        super.m_46061_();
        if (!this.hasKnockback) {
            this.m_46078_().clear();
        }
    }

    public void m_46075_(boolean spawnParticles) {
        super.m_46075_(false);
        if (spawnParticles) {
            this.f_46012_.m_7106_((ParticleOptions)ModRegistry.FIREBALL_EMITTER_PARTICLE.get(), this.f_46013_, this.f_46014_, this.f_46015_, (double)this.f_46017_, 0.0, 0.0);
        }
        if (!this.f_46009_) {
            return;
        }
        for (BlockPos pos : this.visitedBlock) {
            BlockState state = this.f_46012_.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof ILightable) {
                ILightable l = (ILightable)block;
                l.interactWithEntity(this.f_46012_, state, this.m_253049_(), pos);
                continue;
            }
            if (state.m_60734_() != Blocks.f_50016_) continue;
            this.f_46012_.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)pos));
        }
    }

    public boolean hasKnockback() {
        return this.hasKnockback;
    }

    public boolean hurtHitEntity(Entity entity, DamageSource source, float amount) {
        if (this.maxDamage > 0.0f && amount > this.maxDamage) {
            amount = this.maxDamage;
        }
        int oldFire = entity.m_20094_();
        entity.m_20254_(this.onFireTicks);
        if (!entity.m_6469_(source, amount)) {
            entity.m_7311_(oldFire);
            return false;
        }
        return true;
    }

    public void setBlockOnFire(BlockPos pos, BlockState state) {
        this.visitedBlock.add(pos);
    }

    public boolean playExplosionSound() {
        this.f_46012_.m_7785_(this.f_46013_, this.f_46014_, this.f_46015_, ModRegistry.FIREBALL_EXPLOSION_SOUND.get(), SoundSource.BLOCKS, this.soundVolume, (1.0f + (this.f_46012_.f_46441_.m_188501_() - this.f_46012_.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        return false;
    }

    public static class ExtraSettings {
        public float soundVolume = 4.0f;
        public float maxDamage = Float.MAX_VALUE;
        public int onFireTicks = 0;
        public boolean hasKnockback = false;
    }
}

