/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.DummyRegistryAccess;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class ShapedRecipeNoMirror
extends ShapedRecipe {
    private final NonNullList<Ingredient> recipeItemsIn;
    public static final Serializer SERIALIZER = new Serializer();

    public ShapedRecipeNoMirror(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, CraftingBookCategory.MISC, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.recipeItemsIn = recipeItemsIn;
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        for (int i = 0; i <= inv.m_39347_() - this.getRecipeWidth(); ++i) {
            for (int j = 0; j <= inv.m_39346_() - this.getRecipeHeight(); ++j) {
                if (!this.checkMatch(inv, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingContainer craftingInventory, int width, int height) {
        for (int i = 0; i < craftingInventory.m_39347_(); ++i) {
            for (int j = 0; j < craftingInventory.m_39346_(); ++j) {
                int k = i - width;
                int l = j - height;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.getRecipeWidth() && l < this.getRecipeHeight()) {
                    ingredient = (Ingredient)this.recipeItemsIn.get(k + l * this.getRecipeWidth());
                }
                if (ingredient.test(craftingInventory.m_8020_(i + j * craftingInventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public ShapedRecipe m_6729_(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe r = super.m_6729_(recipeId, json);
            return new ShapedRecipeNoMirror(r.m_6423_(), r.m_6076_(), r.getRecipeWidth(), r.getRecipeHeight(), (NonNullList<Ingredient>)r.m_7527_(), r.m_8043_((RegistryAccess)DummyRegistryAccess.INSTANCE));
        }

        @Nullable
        public ShapedRecipe m_8005_(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe r = super.m_8005_(recipeId, buffer);
            return new ShapedRecipeNoMirror(r.m_6423_(), r.m_6076_(), r.getRecipeWidth(), r.getRecipeHeight(), (NonNullList<Ingredient>)r.m_7527_(), r.m_8043_((RegistryAccess)DummyRegistryAccess.INSTANCE));
        }

        public void m_6178_(FriendlyByteBuf buffer, ShapedRecipe recipe) {
            super.m_6178_(buffer, recipe);
        }
    }
}

