/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.ITubeNetworkConnector;
import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.api.block.PressureTubeConnection;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.TubeModuleItem;
import me.desht.pneumaticcraft.common.tubemodules.AbstractNetworkedRedstoneModule;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.tubemodules.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class PressureTubeBlock
extends AbstractCamouflageBlock
implements SimpleWaterloggedBlock,
PneumaticCraftEntityBlock,
ITubeNetworkConnector {
    private static final int TUBE_WIDTH = 2;
    public static final int CORE_MIN = 6;
    public static final int CORE_MAX = 10;
    private static final double PLUG_SIZE = 2.5;
    private static final VoxelShape CORE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape[] ARM_CONNECTED = new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0), Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)};
    private static final VoxelShape[] ARM_CLOSED = new VoxelShape[]{Block.m_49796_((double)6.0, (double)3.5, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)12.5, (double)10.0), Block.m_49796_((double)6.0, (double)6.0, (double)3.5, (double)10.0, (double)10.0, (double)6.0), Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)12.5), Block.m_49796_((double)3.5, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)12.5, (double)10.0, (double)10.0)};
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[729];
    private static final EnumProperty<PressureTubeConnection>[] CONNECTION_PROPERTIES_3 = new EnumProperty[]{PNCBlockStateProperties.PressureTubes.DOWN, PNCBlockStateProperties.PressureTubes.UP, PNCBlockStateProperties.PressureTubes.NORTH, PNCBlockStateProperties.PressureTubes.SOUTH, PNCBlockStateProperties.PressureTubes.WEST, PNCBlockStateProperties.PressureTubes.EAST};
    private final BiFunction<BlockPos, BlockState, ? extends PressureTubeBlockEntity> teFactory;

    public PressureTubeBlock(BiFunction<BlockPos, BlockState, ? extends PressureTubeBlockEntity> teFactory) {
        super(ModBlocks.defaultProps().m_60955_());
        this.teFactory = teFactory;
        BlockState state = this.m_49966_();
        for (EnumProperty<PressureTubeConnection> p : CONNECTION_PROPERTIES_3) {
            state = (BlockState)state.m_61124_(p, (Comparable)((Object)PressureTubeConnection.OPEN));
        }
        this.m_49959_(state);
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return this.teFactory.apply(pPos, pState);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(CONNECTION_PROPERTIES_3);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        if (state == null) {
            return null;
        }
        ArrayList<Direction> l = new ArrayList<Direction>();
        for (Direction dir : DirectionUtil.VALUES) {
            BlockEntity te = ctx.m_43725_().m_7702_(ctx.m_8083_().m_121945_(dir));
            if (te == null || !te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, dir.m_122424_()).isPresent()) continue;
            state = PressureTubeBlock.setSide(state, dir, PressureTubeConnection.CONNECTED);
            l.add(dir);
            if (l.size() > 1) break;
        }
        if (l.size() == 1) {
            state = PressureTubeBlock.setSide(state, ((Direction)l.get(0)).m_122424_(), PressureTubeConnection.CONNECTED);
        }
        return state;
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = PressureTubeBlock.recalculateState(worldIn, currentPos, stateIn);
        if (worldIn instanceof Level) {
            Level level = (Level)worldIn;
            ModuleNetworkManager.getInstance(level).invalidateCache();
            AbstractNetworkedRedstoneModule.onNetworkReform(level, currentPos);
        }
        return newState == null ? super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos) : newState;
    }

    public static BlockState recalculateState(LevelAccessor worldIn, BlockPos currentPos, BlockState stateIn) {
        PressureTubeBlockEntity tePT = PressureTubeBlock.getPressureTube((BlockGetter)worldIn, currentPos);
        if (tePT != null) {
            tePT.clearCachedShape();
            BlockState state = stateIn;
            for (Direction dir : DirectionUtil.VALUES) {
                BlockEntity neighbourTE;
                PressureTubeConnection type = PressureTubeConnection.OPEN;
                if (tePT.isSideClosed(dir)) {
                    type = PressureTubeConnection.CLOSED;
                } else if (tePT.canConnectPneumatic(dir) && (neighbourTE = tePT.getCachedNeighbor(dir)) != null && neighbourTE.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, dir.m_122424_()).isPresent()) {
                    type = PressureTubeConnection.CONNECTED;
                }
                state = PressureTubeBlock.setSide(state, dir, type);
            }
            return PressureTubeBlock.checkForSingleConnection(tePT, state);
        }
        return stateIn;
    }

    private static BlockState checkForSingleConnection(PressureTubeBlockEntity te, BlockState state) {
        ArrayList<Direction> connected = new ArrayList<Direction>();
        int nUnconnected = 0;
        for (Direction dir : DirectionUtil.VALUES) {
            if (te.getModule(dir) != null) {
                return state;
            }
            switch ((PressureTubeConnection)((Object)state.m_61143_(CONNECTION_PROPERTIES_3[dir.m_122411_()]))) {
                case CONNECTED: {
                    connected.add(dir);
                    break;
                }
                case OPEN: {
                    ++nUnconnected;
                    break;
                }
                case CLOSED: {
                    return state;
                }
            }
            if (connected.size() > 1) break;
        }
        if (nUnconnected == 5 && connected.size() == 1) {
            state = PressureTubeBlock.setSide(state, ((Direction)connected.get(0)).m_122424_(), PressureTubeConnection.CONNECTED);
        }
        return state;
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        VoxelShape res = this.getCachedShape(state);
        PressureTubeBlockEntity te = PressureTubeBlock.getPressureTube(reader, pos);
        return te != null ? te.getCachedTubeShape(res) : res;
    }

    private VoxelShape getCachedShape(BlockState state) {
        int idx = 0;
        int mul = 1;
        for (Direction d : Direction.values()) {
            idx += ((PressureTubeConnection)((Object)state.m_61143_(CONNECTION_PROPERTIES_3[d.m_122411_()]))).getIndex() * mul;
            mul *= 3;
        }
        if (SHAPE_CACHE[idx] == null) {
            VoxelShape res = CORE;
            block5: for (Direction d : Direction.values()) {
                switch ((PressureTubeConnection)((Object)state.m_61143_(CONNECTION_PROPERTIES_3[d.m_122411_()]))) {
                    case CONNECTED: {
                        res = Shapes.m_83113_((VoxelShape)res, (VoxelShape)ARM_CONNECTED[d.m_122411_()], (BooleanOp)BooleanOp.f_82695_);
                        continue block5;
                    }
                    case CLOSED: {
                        res = Shapes.m_83113_((VoxelShape)res, (VoxelShape)ARM_CLOSED[d.m_122411_()], (BooleanOp)BooleanOp.f_82695_);
                    }
                }
            }
            PressureTubeBlock.SHAPE_CACHE[idx] = res;
        }
        return SHAPE_CACHE[idx];
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        AbstractTubeModule module;
        if (this.tryPlaceModule(player, world, pos, brtr.m_82434_(), hand, false)) {
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_() && (module = PressureTubeBlock.getFocusedModule(world, pos, player)) != null) {
            return module.onActivated(player, hand) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return super.m_6227_(state, world, pos, player, hand, brtr);
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        PressureTubeBlockEntity te = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
        if (!world.m_5776_() && te != null) {
            te.onNeighborTileUpdate(null);
        }
    }

    public boolean tryPlaceModule(Player player, Level world, BlockPos pos, Direction side, InteractionHand hand, boolean simulate) {
        AbstractTubeModule module;
        PressureTubeBlockEntity tePT = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
        if (tePT == null) {
            return false;
        }
        ItemStack heldStack = player.m_21120_(hand);
        Item item = heldStack.m_41720_();
        if (item instanceof TubeModuleItem) {
            TubeModuleItem tubeModuleItem = (TubeModuleItem)item;
            module = tubeModuleItem.createModule(side, tePT);
            if (tePT.mayPlaceModule(module)) {
                if (simulate) {
                    module.markFake();
                }
                tePT.setModule(side, module);
                if (!simulate && !world.f_46443_) {
                    this.m_6861_(world.m_8055_(pos), world, pos, this, pos.m_121945_(side), false);
                    world.m_46672_(pos, (Block)this);
                    if (!player.m_7500_()) {
                        heldStack.m_41774_(1);
                    }
                    world.m_5594_(null, pos, SoundType.f_56744_.m_56776_(), SoundSource.BLOCKS, SoundType.f_56744_.m_56773_() * 5.0f, SoundType.f_56744_.m_56774_() * 0.9f);
                    if (module instanceof INetworkedModule) {
                        ModuleNetworkManager.getInstance(world).invalidateCache();
                    }
                }
                if (!simulate) {
                    module.onPlaced();
                }
                return true;
            }
        } else if (heldStack.m_41720_() == ModItems.MODULE_EXPANSION_CARD.get() && !simulate && (module = PressureTubeBlock.getFocusedModule(world, pos, player)) != null && !module.isUpgraded() && module.canUpgrade()) {
            if (!world.f_46443_) {
                module.upgrade();
                tePT.m_6596_();
                tePT.sendDescriptionPacket();
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
            }
            return true;
        }
        return false;
    }

    public static AbstractTubeModule getFocusedModule(Level world, BlockPos pos, Player player) {
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockState state = world.m_8055_(pos);
        BlockHitInfo rayTraceResult = PressureTubeBlock.doTrace(state, (BlockGetter)world, pos, (Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        TubeHitInfo tubeHitInfo = rayTraceResult.tubeHitInfo();
        if (tubeHitInfo.type == TubeHitInfo.PartType.MODULE) {
            PressureTubeBlockEntity tube = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
            return tube == null ? null : tube.getModule(tubeHitInfo.dir);
        }
        return null;
    }

    private static BlockState setSide(BlockState state, Direction side, PressureTubeConnection type) {
        return (BlockState)state.m_61124_(CONNECTION_PROPERTIES_3[side.m_122411_()], (Comparable)((Object)type));
    }

    private static PressureTubeBlockEntity getPressureTube(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return te instanceof PressureTubeBlockEntity ? (PressureTubeBlockEntity)te : null;
    }

    private static Pair<Boolean, Direction> getLookedTube(BlockGetter world, BlockPos pos, Player player) {
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockState state = world.m_8055_(pos);
        BlockHitInfo blockHitInfo = PressureTubeBlock.doTrace(state, world, pos, (Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        TubeHitInfo tubeHitInfo = blockHitInfo.tubeHitInfo();
        if (tubeHitInfo.type == TubeHitInfo.PartType.TUBE) {
            return tubeHitInfo.dir == null ? Pair.of((Object)true, (Object)Objects.requireNonNull(blockHitInfo.res()).m_82434_()) : Pair.of((Object)false, (Object)tubeHitInfo.dir);
        }
        return null;
    }

    @Nonnull
    private static BlockHitInfo doTrace(BlockState state, BlockGetter world, BlockPos pos, Vec3 origin, Vec3 direction) {
        PressureTubeBlockEntity tube;
        BlockHitResult bestRTR = null;
        TubeHitInfo hitInfo = TubeHitInfo.NO_HIT;
        BlockHitResult brtr = AABB.m_82342_(Collections.singletonList(CORE.m_83215_()), (Vec3)origin, (Vec3)direction, (BlockPos)pos);
        if (brtr != null) {
            hitInfo = TubeHitInfo.CENTER;
            bestRTR = brtr;
        }
        if ((tube = PressureTubeBlock.getPressureTube(world, pos)) == null) {
            return new BlockHitInfo(BlockHitResult.m_82426_((Vec3)origin, (Direction)Direction.UP, (BlockPos)pos), TubeHitInfo.NO_HIT);
        }
        for (int i = 0; i < 6; ++i) {
            AABB arm;
            switch ((PressureTubeConnection)((Object)state.m_61143_(CONNECTION_PROPERTIES_3[i]))) {
                case CLOSED: {
                    AABB aABB = ARM_CLOSED[i].m_83215_();
                    break;
                }
                case CONNECTED: {
                    AABB aABB = ARM_CONNECTED[i].m_83215_();
                    break;
                }
                default: {
                    AABB aABB = arm = null;
                }
            }
            if (arm == null || (brtr = AABB.m_82342_(Collections.singletonList(arm), (Vec3)origin, (Vec3)direction, (BlockPos)pos)) == null || !PressureTubeBlock.isCloserIntersection(origin, (HitResult)bestRTR, (HitResult)brtr)) continue;
            hitInfo = new TubeHitInfo(Direction.m_122376_((int)i), TubeHitInfo.PartType.TUBE);
            bestRTR = brtr;
        }
        for (Direction dir : DirectionUtil.VALUES) {
            AABB tubeAABB;
            AbstractTubeModule tm = tube.getModule(dir);
            if (tm == null || !PressureTubeBlock.isCloserIntersection(origin, (HitResult)bestRTR, (HitResult)(brtr = AABB.m_82342_(Collections.singletonList(tubeAABB = tm.getShape().m_83215_()), (Vec3)origin, (Vec3)direction, (BlockPos)pos))) && !tm.isInlineAndFocused(hitInfo)) continue;
            hitInfo = new TubeHitInfo(dir, TubeHitInfo.PartType.MODULE);
            bestRTR = brtr;
        }
        return new BlockHitInfo(bestRTR, hitInfo);
    }

    private static boolean isCloserIntersection(Vec3 origin, HitResult oldRTR, HitResult newRTR) {
        return newRTR != null && (oldRTR == null || origin.m_82557_(newRTR.m_82450_()) <= origin.m_82557_(oldRTR.m_82450_()));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        AbstractTubeModule tm;
        PressureTubeBlockEntity tube;
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockHitInfo rayTraceResult = PressureTubeBlock.doTrace(state, world, pos, (Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        TubeHitInfo tubeHitInfo = rayTraceResult.tubeHitInfo();
        if (tubeHitInfo.type == TubeHitInfo.PartType.TUBE) {
            return super.getCloneItemStack(state, target, world, pos, player);
        }
        if (tubeHitInfo.type == TubeHitInfo.PartType.MODULE && (tube = PressureTubeBlock.getPressureTube(world, pos)) != null && (tm = tube.getModule(tubeHitInfo.dir)) != null) {
            return new ItemStack((ItemLike)tm.getItem());
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (player == null) {
            return false;
        }
        PressureTubeBlockEntity tube = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
        if (tube == null) {
            return false;
        }
        AbstractTubeModule module = PressureTubeBlock.getFocusedModule(world, pos, player);
        if (player.m_6144_()) {
            if (module != null) {
                if (!player.m_7500_()) {
                    for (ItemStack drop : module.getDrops()) {
                        ItemEntity entity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, drop);
                        world.m_7967_((Entity)entity);
                        entity.m_6123_(player);
                    }
                }
                tube.setModule(module.getDirection(), null);
                this.m_6861_(world.m_8055_(pos), world, pos, this, pos.m_121945_(side), false);
                world.m_46672_(pos, (Block)this);
            } else {
                if (!player.m_7500_()) {
                    PressureTubeBlock.m_49892_((BlockState)world.m_8055_(pos), (LevelAccessor)world, (BlockPos)pos, (BlockEntity)tube);
                }
                PressureTubeBlock.removeBlockSneakWrenched(world, pos);
            }
        } else if (module != null) {
            module.onActivated(player, hand);
        } else {
            Pair<Boolean, Direction> lookData = PressureTubeBlock.getLookedTube((BlockGetter)world, pos, player);
            if (lookData != null) {
                Direction sideHit;
                this.setTubeSideClosed(tube, sideHit, !tube.isSideClosed(sideHit = (Direction)lookData.getRight()));
                if (tube.isSideClosed(sideHit)) {
                    PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos.m_121945_(sideHit), PressureTubeBlockEntity.class).ifPresent(tube2 -> {
                        if (this.shouldCloseNeighbor((PressureTubeBlockEntity)tube2, sideHit)) {
                            this.setTubeSideClosed((PressureTubeBlockEntity)tube2, sideHit.m_122424_(), true);
                        }
                    });
                }
            }
        }
        return true;
    }

    private boolean shouldCloseNeighbor(PressureTubeBlockEntity tube2, Direction offset) {
        boolean doClose = false;
        for (Direction d : DirectionUtil.VALUES) {
            if (tube2.getConnectedNeighbor(d) == null) continue;
            if (d.m_122434_() == offset.m_122434_()) {
                doClose = true;
                continue;
            }
            return false;
        }
        return doClose;
    }

    private void setTubeSideClosed(PressureTubeBlockEntity tube, Direction side, boolean closed) {
        tube.setSideClosed(side, closed);
        Level world = tube.nonNullLevel();
        BlockPos pos = tube.m_58899_();
        world.m_46597_(pos, PressureTubeBlock.recalculateState((LevelAccessor)world, pos, world.m_8055_(pos)));
        PneumaticRegistry.getInstance().getMiscHelpers().forceClientShapeRecalculation(world, pos);
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() != state.m_60734_()) {
            PressureTubeBlock.getModuleDrops(PressureTubeBlock.getPressureTube((BlockGetter)world, pos)).forEach(drop -> world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, drop)));
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    private static NonNullList<ItemStack> getModuleDrops(PressureTubeBlockEntity tube) {
        NonNullList drops = NonNullList.m_122779_();
        if (tube != null) {
            tube.tubeModules().map(AbstractTubeModule::getDrops).forEach(arg_0 -> drops.addAll(arg_0));
        }
        return drops;
    }

    public int m_6378_(BlockState state, BlockGetter par1IBlockAccess, BlockPos pos, Direction side) {
        PressureTubeBlockEntity tePt = PressureTubeBlock.getPressureTube(par1IBlockAccess, pos);
        if (tePt != null) {
            int redstoneLevel = 0;
            for (Direction face : DirectionUtil.VALUES) {
                AbstractTubeModule tm = tePt.getModule(face);
                if (tm == null || side.m_122424_() != face && (face == side || !tm.isInline())) continue;
                redstoneLevel = Math.max(redstoneLevel, tm.getRedstoneLevel());
            }
            return redstoneLevel;
        }
        return 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        PressureTubeConnection[] conns = new PressureTubeConnection[DirectionUtil.HORIZONTALS.length];
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            conns[rotation.m_55954_((Direction)dir).m_122416_()] = (PressureTubeConnection)((Object)state.m_61143_(CONNECTION_PROPERTIES_3[dir.m_122411_()]));
        }
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            state = (BlockState)state.m_61124_(CONNECTION_PROPERTIES_3[dir.m_122411_()], (Comparable)((Object)conns[dir.m_122416_()]));
        }
        return super.m_6843_(state, rotation);
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        PressureTubeConnection[] conns = new PressureTubeConnection[DirectionUtil.HORIZONTALS.length];
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            Rotation r = mirrorIn.m_54846_(dir);
            conns[r.m_55954_((Direction)dir).m_122416_()] = (PressureTubeConnection)((Object)state.m_61143_(CONNECTION_PROPERTIES_3[dir.m_122411_()]));
        }
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            state = (BlockState)state.m_61124_(CONNECTION_PROPERTIES_3[dir.m_122411_()], (Comparable)((Object)conns[dir.m_122416_()]));
        }
        return super.m_6943_(state, mirrorIn);
    }

    @Override
    public boolean canConnectToNetwork(Level level, BlockPos pos, Direction dir, BlockState state) {
        return state.m_61138_(CONNECTION_PROPERTIES_3[dir.m_122411_()]) && state.m_61143_(CONNECTION_PROPERTIES_3[dir.m_122411_()]) == PressureTubeConnection.CONNECTED;
    }

    private record BlockHitInfo(BlockHitResult res, @Nonnull TubeHitInfo tubeHitInfo) {
    }

    public record TubeHitInfo(Direction dir, PartType type) {
        static final TubeHitInfo NO_HIT = new TubeHitInfo(null, null);
        public static final TubeHitInfo CENTER = new TubeHitInfo(null, PartType.TUBE);

        static enum PartType {
            TUBE,
            MODULE;

        }
    }
}

