/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import org.apache.commons.lang3.Validate;

public class SideConfigurator<T>
implements INBTSerializable<CompoundTag> {
    public static final String BASE_BUTTON_TAG = "SideConf";
    private final List<ConnectionEntry<T>> entries = new ArrayList<ConnectionEntry<T>>();
    private final String id;
    private final ISideConfigurable sideConfigurable;
    private final Map<String, Integer> idxMap = new HashMap<String, Integer>();
    private LazyOptional<T> nullFaceCap = LazyOptional.empty();
    private final byte[] faces = new byte[RelativeFace.values().length];
    private final byte[] defaultFaces = new byte[RelativeFace.values().length];
    private final RelativeFace[][] facingMatrix = new RelativeFace[4][];

    SideConfigurator(String id, ISideConfigurable sideConfigurable) {
        this.id = id;
        this.sideConfigurable = sideConfigurable;
        this.entries.add(null);
        this.setupFacingMatrix();
    }

    public int registerHandler(String id, ItemStack textureStack, Capability<T> cap, NonNullSupplier<T> handler, RelativeFace ... defaultRelativeFaces) {
        this.entries.add(new ConnectionEntry<T>(id, textureStack, cap, handler));
        this.idxMap.put(id, this.entries.size() - 1);
        return this.setDefaultSides(defaultRelativeFaces);
    }

    public int registerHandler(String id, ResourceLocation texture, Capability<T> cap, NonNullSupplier<T> handler, RelativeFace ... defaultRelativeFaces) {
        this.entries.add(new ConnectionEntry<T>(id, texture, cap, handler));
        this.idxMap.put(id, this.entries.size() - 1);
        return this.setDefaultSides(defaultRelativeFaces);
    }

    public void unregisterHandlers(Predicate<String> idMatcher) {
        ArrayList<ConnectionEntry<T>> newEntries = new ArrayList<ConnectionEntry<T>>();
        for (String id : this.idxMap.keySet()) {
            if (idMatcher.test(id)) continue;
            newEntries.add(this.entries.get(this.idxMap.get(id)));
        }
        this.entries.clear();
        this.entries.addAll(newEntries);
        this.idxMap.clear();
        for (int i = 0; i < this.entries.size(); ++i) {
            this.idxMap.put(this.entries.get((int)i).id, i);
        }
    }

    public void invalidateCaps() {
        for (ConnectionEntry<T> e : this.entries) {
            if (e == null || e.lazy == null) continue;
            e.lazy.invalidate();
        }
    }

    private int setDefaultSides(RelativeFace ... defaultRelativeFaces) {
        Validate.isTrue((this.entries.size() <= 127 ? 1 : 0) != 0, (String)"No more than 127 entries allowed", (Object[])new Object[0]);
        byte idx = (byte)(this.entries.size() - 1);
        for (RelativeFace relativeFace : defaultRelativeFaces) {
            this.faces[relativeFace.ordinal()] = idx;
            this.defaultFaces[relativeFace.ordinal()] = idx;
        }
        return idx;
    }

    void setNullFaceHandler(String id) {
        if (this.nullFaceCap.isPresent()) {
            this.nullFaceCap.invalidate();
        }
        this.nullFaceCap = LazyOptional.of(this.entries.get((int)this.idxMap.get((Object)id).intValue()).handler);
    }

    private boolean shouldSaveNBT() {
        return !Arrays.equals(this.faces, this.defaultFaces);
    }

    void updateHandler(String id, NonNullSupplier<T> handler) {
        int idx = this.idxMap.get(id);
        ConnectionEntry<T> e = this.entries.get(idx);
        this.entries.set(idx, new ConnectionEntry(e.id, e.texture, e.cap, handler));
        this.setNullFaceHandler(id);
    }

    public byte[] getFaces() {
        return this.faces;
    }

    public void setFaces(byte[] faces) {
        System.arraycopy(faces, 0, this.faces, 0, this.faces.length);
    }

    public boolean handleButtonPress(String tag, boolean hasShiftDown) {
        if (tag.startsWith(BASE_BUTTON_TAG)) {
            try {
                RelativeFace relativeFace = RelativeFace.valueOf(tag.split("\\.")[1]);
                this.cycleValue(relativeFace, hasShiftDown);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getButtonTag(RelativeFace relativeFace) {
        return "SideConf." + relativeFace.toString();
    }

    private void cycleValue(RelativeFace relativeFace, boolean hasShiftDown) {
        int idx = relativeFace.ordinal();
        int n = 0;
        while (n++ < this.entries.size()) {
            ConnectionEntry<T> c;
            if (hasShiftDown) {
                int n2 = idx;
                this.faces[n2] = (byte)(this.faces[n2] - 1);
                if (this.faces[n2] < 0) {
                    this.faces[idx] = (byte)(this.entries.size() - 1);
                }
            } else {
                int n3 = idx;
                this.faces[n3] = (byte)(this.faces[n3] + 1);
                if (this.faces[n3] >= this.entries.size()) {
                    this.faces[idx] = 0;
                }
            }
            if (!this.sideConfigurable.isValid(relativeFace, (c = this.entries.get(this.faces[idx])) == null ? null : c.cap)) continue;
            return;
        }
    }

    public String getID() {
        return this.id;
    }

    public String getTranslationKey() {
        return "pneumaticcraft.gui.sideConfigurator.title." + this.id;
    }

    LazyOptional<T> getHandler(Direction facing) {
        if (facing == null) {
            return this.nullFaceCap;
        }
        ConnectionEntry<T> c = this.entries.get(this.faces[this.getRelativeFace(facing).ordinal()]);
        return c == null ? LazyOptional.empty() : c.lazy;
    }

    void setupFacingMatrix() {
        for (Direction f : DirectionUtil.HORIZONTALS) {
            this.facingMatrix[f.m_122416_()] = new RelativeFace[4];
            for (RelativeFace rf : RelativeFace.HORIZONTALS) {
                Direction f2 = this.rot(f, rf);
                this.facingMatrix[f.m_122416_()][f2.m_122416_()] = rf;
            }
        }
    }

    private Direction rot(Direction in, RelativeFace rf) {
        return switch (rf) {
            case RelativeFace.RIGHT -> in.m_122428_();
            case RelativeFace.LEFT -> in.m_122427_();
            case RelativeFace.BACK -> in.m_122424_();
            default -> in;
        };
    }

    private RelativeFace getRelativeFace(Direction facing) {
        if (facing == Direction.UP) {
            return RelativeFace.TOP;
        }
        if (facing == Direction.DOWN) {
            return RelativeFace.BOTTOM;
        }
        return this.facingMatrix[this.sideConfigurable.byIndex().m_122416_()][facing.m_122416_()];
    }

    public Component getFaceLabel(RelativeFace relativeFace) {
        ConnectionEntry<T> c = this.entries.get(this.faces[relativeFace.ordinal()]);
        return c == null ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.sideConfigurator.unconnected", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.sideConfigurator." + this.id + "." + c.id, new Object[0]);
    }

    public ConnectionEntry<?> getEntry(RelativeFace face) {
        return this.entries.get(this.faces[face.ordinal()]);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag l = new ListTag();
        for (byte face : this.faces) {
            l.add((Object)ByteTag.m_128266_((byte)face));
        }
        tag.m_128365_("faces", (Tag)l);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag l = nbt.m_128437_("faces", 1);
        for (int i = 0; i < l.size() && i < this.faces.length; ++i) {
            this.faces[i] = ((ByteTag)l.get(i)).m_7063_();
            if (this.faces[i] >= 0 && this.faces[i] < this.entries.size()) continue;
            this.faces[i] = 0;
        }
    }

    public static CompoundTag writeToNBT(ISideConfigurable sideConfigurable) {
        CompoundTag tag = new CompoundTag();
        for (SideConfigurator<?> sc : sideConfigurable.getSideConfigurators()) {
            if (!sc.shouldSaveNBT()) continue;
            CompoundTag subtag = sc.serializeNBT();
            tag.m_128365_(sc.id, (Tag)subtag);
        }
        return tag;
    }

    public static void readFromNBT(CompoundTag tag, ISideConfigurable sideConfigurable) {
        for (SideConfigurator<?> sc : sideConfigurable.getSideConfigurators()) {
            if (!tag.m_128441_(sc.id)) continue;
            CompoundTag subtag = tag.m_128469_(sc.id);
            sc.deserializeNBT(subtag);
        }
    }

    public static enum RelativeFace {
        BOTTOM,
        TOP,
        LEFT,
        RIGHT,
        FRONT,
        BACK;

        public static final RelativeFace[] HORIZONTALS;

        static {
            HORIZONTALS = new RelativeFace[4];
            RelativeFace.HORIZONTALS[0] = LEFT;
            RelativeFace.HORIZONTALS[1] = RIGHT;
            RelativeFace.HORIZONTALS[2] = FRONT;
            RelativeFace.HORIZONTALS[3] = BACK;
        }
    }

    public static class ConnectionEntry<T> {
        private final String id;
        private final Object texture;
        private final Capability<T> cap;
        private final NonNullSupplier<T> handler;
        private final LazyOptional<T> lazy;

        private ConnectionEntry(String id, Object texture, Capability<T> cap, NonNullSupplier<T> handler) {
            this.id = id;
            this.texture = texture;
            this.cap = cap;
            this.handler = handler;
            this.lazy = LazyOptional.of(handler);
        }

        public Object getTexture() {
            return this.texture;
        }
    }
}

