/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;

public class DroneAINearestAttackableTarget
extends TargetGoal {
    private final DroneEntity drone;
    private final ProgWidget widget;
    private final DistanceSorter distanceSorter;
    private LivingEntity targetEntity;

    public DroneAINearestAttackableTarget(DroneEntity drone, boolean mustSee, ProgWidget widget) {
        super((Mob)drone, mustSee, false);
        this.drone = drone;
        this.widget = widget;
        this.distanceSorter = new DistanceSorter((Entity)drone);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        IMaxActions m;
        if (this.drone.hasMinigun() && this.drone.getSlotForAmmo() < 0) {
            return false;
        }
        ProgWidget progWidget = this.widget;
        if (progWidget instanceof IMaxActions && (m = (IMaxActions)((Object)progWidget)).useMaxActions() && this.drone.getAttackCount() >= m.getMaxActions()) {
            return false;
        }
        progWidget = this.widget;
        if (!(progWidget instanceof IEntityProvider)) {
            return false;
        }
        IEntityProvider provider = (IEntityProvider)((Object)progWidget);
        List<Entity> list = provider.getValidEntities(this.drone.m_9236_());
        list.sort(this.distanceSorter);
        for (Entity entity : list) {
            if (!entity.m_6084_() || entity == this.f_26135_ || !(entity instanceof LivingEntity) || this.shouldIgnore(entity)) continue;
            this.targetEntity = (LivingEntity)entity;
            return true;
        }
        return false;
    }

    private boolean shouldIgnore(Entity entity) {
        return entity.m_5833_() || entity instanceof Player && ((Player)entity).m_7500_() || this.f_26136_ && !this.f_26135_.m_21574_().m_148306_(entity);
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.targetEntity);
        super.m_8056_();
    }

    private record DistanceSorter(Entity entity) implements Comparator<Entity>
    {
        @Override
        public int compare(Entity e1, Entity e2) {
            return Double.compare(this.entity.m_20280_(e1), this.entity.m_20280_(e2));
        }
    }
}

