/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.minigun;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.render.MinigunItemRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.ChargingStationUpgradeManagerMenu;
import me.desht.pneumaticcraft.common.inventory.MinigunMagazineMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.item.minigun.StandardGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.minigun.MinigunPlayerTracker;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketMinigunStop;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.Validate;

public class MinigunItem
extends PressurizableItem
implements IChargeableContainerProvider,
IFOVModifierItem,
IInventoryItem,
IShiftScrollable {
    public static final int MAGAZINE_SIZE = 4;
    private static final String NBT_MAGAZINE = "Magazine";
    public static final String NBT_LOCKED_SLOT = "LockedSlot";
    public static final String OWNING_PLAYER_ID = "owningPlayerId";

    public MinigunItem() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new MinigunItemRenderer.RenderProperties());
    }

    @Nonnull
    public MagazineHandler getMagazine(ItemStack stack) {
        Validate.isTrue((boolean)(stack.m_41720_() instanceof MinigunItem));
        return new MagazineHandler(stack);
    }

    public void onEquipmentChange(ServerPlayer player, ItemStack stack, boolean equipping) {
        if (equipping) {
            stack.m_41784_().m_128405_(OWNING_PLAYER_ID, player.m_19879_());
        } else {
            stack.m_41784_().m_128473_(OWNING_PLAYER_ID);
            Minigun minigun = this.getMinigun(stack, (Player)player);
            if (minigun.getMinigunSpeed() > 0.0f || minigun.isMinigunActivated()) {
                NetworkHandler.sendToPlayer(new PacketMinigunStop(stack), player);
            }
            minigun.setMinigunSpeed(0.0f);
            minigun.setMinigunActivated(false);
            minigun.setMinigunTriggerTimeOut(0);
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean currentItem) {
        super.m_6883_(stack, world, entity, slot, currentItem);
        Player player = (Player)entity;
        Minigun minigun = null;
        if (currentItem) {
            minigun = this.getMinigun(stack, player);
            minigun.tick(player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
        if (!world.f_46443_ && slot >= 0 && slot <= 8) {
            if (minigun == null) {
                minigun = this.getMinigun(stack, player);
            }
            this.handleAmmoRepair(stack, world, minigun);
        }
    }

    private void handleAmmoRepair(ItemStack stack, Level world, Minigun minigun) {
        if (minigun.getPlayer().f_36096_ instanceof MinigunMagazineMenu) {
            return;
        }
        int itemLife = minigun.getUpgrades(ModUpgrades.ITEM_LIFE.get());
        if (itemLife > 0) {
            MagazineHandler handler = this.getMagazine(stack);
            boolean repaired = false;
            float pressure = ((IAirHandler)minigun.getAirCapability().orElseThrow(RuntimeException::new)).getPressure();
            if (world.m_46467_() % (200L - (long)itemLife * 35L) == 0L) {
                for (int i = 0; i < handler.getSlots() && pressure > 0.25f; ++i) {
                    ItemStack ammo = handler.getStackInSlot(i);
                    if (!(ammo.m_41720_() instanceof AbstractGunAmmoItem) || ammo.m_41773_() <= 0) continue;
                    ammo.m_41721_(ammo.m_41773_() - 1);
                    if (!minigun.getPlayer().m_7500_()) {
                        minigun.getAirCapability().ifPresent(h -> h.addAir(-(100 * itemLife)));
                    }
                    pressure = ((IAirHandler)minigun.getAirCapability().orElseThrow(RuntimeException::new)).getPressure();
                    repaired = true;
                }
            }
            if (repaired) {
                handler.save();
            }
        }
    }

    private Minigun getMinigun(ItemStack stack, Player player, ItemStack ammo) {
        boolean isCreative = UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.CREATIVE.get()) > 0;
        return new ItemMinigunImpl(player, stack).setAmmoStack(ammo).setAirHandler((LazyOptional<? extends IAirHandler>)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY), isCreative ? 0 : 20).setWorld(player.m_9236_()).setInfiniteAmmo(isCreative);
    }

    public Minigun getMinigun(ItemStack stack, Player player) {
        return this.getMinigun(stack, player, this.getMagazine(stack).getAmmo());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, final InteractionHand handIn) {
        final ItemStack stack = player.m_21120_(handIn);
        if (player.m_6144_()) {
            if (!world.f_46443_ && stack.m_41613_() == 1) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return stack.m_41786_();
                    }

                    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                        return new MinigunMagazineMenu(i, playerInventory, handIn);
                    }
                }, buf -> AbstractPneumaticCraftMenu.putHand(buf, handIn));
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        MagazineHandler magazineHandler = this.getMagazine(stack);
        ItemStack ammo = magazineHandler.getAmmo();
        if (!ammo.m_41619_()) {
            player.m_6672_(handIn);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
        }
        if (player.m_9236_().f_46443_) {
            player.m_5496_(SoundEvents.f_11762_, 1.0f, 1.0f);
            player.m_5661_((Component)Component.m_237115_((String)"pneumaticcraft.message.minigun.outOfAmmo"), true);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5929_(Level pLevel, LivingEntity entity, ItemStack stack, int pRemainingUseDuration) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MagazineHandler magazineHandler = this.getMagazine(stack);
        ItemStack ammo = magazineHandler.getAmmo();
        if (!ammo.m_41619_()) {
            boolean usedUpAmmo;
            int prevDamage = ammo.m_41773_();
            Minigun minigun = this.getMinigun(stack, player, ammo);
            boolean bl = usedUpAmmo = minigun.tryFireMinigun(null) && minigun.getUpgrades(ModUpgrades.ITEM_LIFE.get()) == 0;
            if (usedUpAmmo) {
                ammo.m_41764_(0);
            }
            if (usedUpAmmo || ammo.m_41773_() != prevDamage) {
                magazineHandler.save();
            }
        } else {
            if (player.m_9236_().f_46443_) {
                player.m_5496_(SoundEvents.f_11762_, 1.0f, 1.0f);
                player.m_5661_((Component)Component.m_237115_((String)"pneumaticcraft.message.minigun.outOfAmmo"), true);
            }
            player.m_21253_();
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        return super.m_5922_(stack, worldIn, entityLiving);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public float getFOVModifier(ItemStack stack, Player player, EquipmentSlot slot) {
        Minigun minigun = this.getMinigun(stack, player);
        int trackers = minigun.getUpgrades(ModUpgrades.ENTITY_TRACKER.get());
        if (!minigun.isMinigunActivated() || trackers == 0) {
            return 1.0f;
        }
        return 1.0f - (float)trackers * minigun.getMinigunSpeed() / 2.0f;
    }

    @Override
    public void getStacksInItem(ItemStack stack, List<ItemStack> curStacks) {
        MagazineHandler handler = this.getMagazine(stack);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            curStacks.add(handler.getStackInSlot(i));
        }
    }

    @Override
    public Component getInventoryHeader() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo.loaded", new Object[0]).m_130940_(ChatFormatting.GREEN);
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, (MenuType<? extends ChargingStationUpgradeManagerMenu>)((MenuType)ModMenuTypes.CHARGING_MINIGUN.get()));
    }

    @Override
    public void onShiftScrolled(Player player, boolean forward, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof MinigunItem) {
            MagazineHandler handler = this.getMagazine(stack);
            int newSlot = Math.max(0, MinigunItem.getLockedSlot(stack));
            for (int i = 0; i < 3; ++i) {
                if ((newSlot += forward ? 1 : -1) < 0) {
                    newSlot = 3;
                } else if (newSlot >= 4) {
                    newSlot = 0;
                }
                ItemStack ammoStack = handler.getStackInSlot(newSlot);
                Item item = ammoStack.m_41720_();
                if (!(item instanceof AbstractGunAmmoItem)) continue;
                AbstractGunAmmoItem ammo = (AbstractGunAmmoItem)item;
                NBTUtils.setInteger(stack, NBT_LOCKED_SLOT, newSlot);
                if (player.m_9236_().f_46443_) continue;
                if (ammo instanceof StandardGunAmmoItem) {
                    ItemStack potion = StandardGunAmmoItem.getPotion(ammoStack);
                    if (!potion.m_41619_()) {
                        int col = PotionUtils.m_43575_((ItemStack)potion);
                        player.m_5661_((Component)potion.m_41611_().m_6881_().m_130948_(Style.f_131099_.m_178520_(col)), true);
                    } else {
                        player.m_5661_((Component)Component.m_237113_((String)" "), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)" "), true);
                }
                return;
            }
        }
    }

    public static int getLockedSlot(ItemStack stack) {
        if (NBTUtils.hasTag(stack, NBT_LOCKED_SLOT)) {
            int slot = NBTUtils.getInteger(stack, NBT_LOCKED_SLOT);
            if (slot >= 0 && slot < 4) {
                return slot;
            }
            Log.warning("removed out of range saved ammo slot: " + slot, new Object[0]);
            NBTUtils.removeTag(stack, NBT_LOCKED_SLOT);
        }
        return -1;
    }

    public static class MagazineHandler
    extends BaseItemStackHandler {
        private final ItemStack gunStack;

        MagazineHandler(ItemStack gunStack) {
            super(4);
            this.gunStack = gunStack;
            if (gunStack.m_41782_() && gunStack.m_41783_().m_128441_(MinigunItem.NBT_MAGAZINE)) {
                this.deserializeNBT(gunStack.m_41783_().m_128469_(MinigunItem.NBT_MAGAZINE));
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || itemStack.m_41720_() instanceof AbstractGunAmmoItem;
        }

        public ItemStack getAmmo() {
            int slot = MinigunItem.getLockedSlot(this.gunStack);
            if (slot >= 0) {
                return this.getStackInSlot(slot);
            }
            for (int i = 0; i < 4; ++i) {
                if (!(this.getStackInSlot(i).m_41720_() instanceof AbstractGunAmmoItem)) continue;
                return this.getStackInSlot(i);
            }
            return ItemStack.f_41583_;
        }

        public void save() {
            if (!this.gunStack.m_41619_()) {
                NBTUtils.setCompoundTag(this.gunStack, MinigunItem.NBT_MAGAZINE, (Tag)this.serializeNBT());
            }
        }
    }

    private static class ItemMinigunImpl
    extends Minigun {
        private final ItemStack minigunStack;
        private final MinigunPlayerTracker tracker;

        ItemMinigunImpl(Player player, ItemStack stack) {
            super(player, false);
            this.tracker = MinigunPlayerTracker.getInstance(player);
            this.minigunStack = stack;
        }

        @Override
        public boolean isMinigunActivated() {
            return this.tracker.isActivated();
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            this.tracker.setActivated(activated);
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!ammo.m_41619_()) {
                this.tracker.setAmmoColor(this.getAmmoColor(ammo));
            } else {
                this.tracker.setAmmoColor(0);
            }
        }

        @Override
        public int getAmmoColor() {
            return this.tracker.getAmmoColor();
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            if (!this.player.m_9236_().f_46443_) {
                NetworkHandler.sendToAllTracking(new PacketPlaySound(soundName, SoundSource.PLAYERS, this.player.m_20183_(), volume, pitch, false), this.player.m_9236_(), this.player.m_20183_());
            }
        }

        @Override
        public Vec3 getMuzzlePosition() {
            float pitch = this.player.m_146909_() * ((float)Math.PI / 180);
            float yaw = -(this.player.m_146908_() + 13.5f) * ((float)Math.PI / 180);
            float f2 = Mth.m_14089_((float)yaw);
            float f3 = Mth.m_14031_((float)yaw);
            float f4 = Mth.m_14089_((float)pitch);
            float f5 = Mth.m_14031_((float)pitch);
            Vec3 lookVec = new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
            return this.player.m_20299_(0.0f).m_82549_(lookVec.m_82490_((double)2.2f)).m_82492_(0.0, 0.3, 0.0);
        }

        @Override
        public Vec3 getLookAngle() {
            return this.player.m_20154_();
        }

        @Override
        public float getParticleScale() {
            return this.player.m_19879_() == ClientUtils.getClientPlayer().m_19879_() && ClientUtils.isFirstPersonCamera() ? 0.4f : 1.0f;
        }

        @Override
        public float getMinigunSpeed() {
            return this.tracker.getRotationSpeed();
        }

        @Override
        public void setMinigunSpeed(float minigunSpeed) {
            this.tracker.setRotationSpeed(minigunSpeed);
        }

        @Override
        public int getMinigunTriggerTimeOut() {
            return this.tracker.getTriggerTimeout();
        }

        @Override
        public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
            this.tracker.setTriggerTimeout(minigunTriggerTimeOut);
        }

        @Override
        public float getMinigunRotation() {
            return this.tracker.getBarrelRotation();
        }

        @Override
        public void setMinigunRotation(float minigunRotation) {
            this.tracker.setBarrelRotation(minigunRotation);
        }

        @Override
        public float getOldMinigunRotation() {
            return this.tracker.getPrevBarrelRotation();
        }

        @Override
        public void setOldMinigunRotation(float oldMinigunRotation) {
            this.tracker.setPrevBarrelRotation(oldMinigunRotation);
        }

        @Override
        public int getUpgrades(PNCUpgrade upgrade) {
            return Math.min(ApplicableUpgradesDB.getInstance().getMaxUpgrades(this.minigunStack.m_41720_(), upgrade), UpgradableItemUtils.getUpgradeCount(this.minigunStack, upgrade));
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Minigun minigun;
                ItemStack stack;
                Player player = (Player)livingEntity;
                if (event.getSource().m_7639_() != null && event.getSource().m_276093_(DamageTypes.f_268440_) && (stack = player.m_21205_()).m_41720_() instanceof MinigunItem && (minigun = ((MinigunItem)stack.m_41720_()).getMinigun(stack, player)) != null && minigun.getMinigunSpeed() >= 0.4f) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

