/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class PacketPneumaticKick {
    public PacketPneumaticKick() {
    }

    public PacketPneumaticKick(FriendlyByteBuf buffer) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int upgrades;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((Player)player);
            if (handler.upgradeUsable(CommonUpgradeHandlers.kickHandler, false) && (upgrades = handler.getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.DISPENSER.get())) > 0) {
                this.handleKick((Player)player, Math.min(4, upgrades));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void handleKick(Player player, int upgrades) {
        Vec3 lookVec = new Vec3(player.m_20154_().f_82479_, Math.max(0.0, player.m_20154_().f_82480_), player.m_20154_().f_82481_).m_82541_();
        double playerFootY = player.m_20186_() - (double)(player.m_20206_() / 2.0f);
        AABB box = new AABB(player.m_20185_(), playerFootY, player.m_20189_(), player.m_20185_(), playerFootY, player.m_20189_()).m_82377_(1.5, 1.5, 1.5).m_82383_(lookVec);
        List entities = player.m_9236_().m_45933_((Entity)player, box);
        if (entities.isEmpty()) {
            return;
        }
        entities.sort(Comparator.comparingDouble(o -> o.m_20280_((Entity)player)));
        Entity target = (Entity)entities.get(0);
        if (!target.m_7313_((Entity)player)) {
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                target.m_6469_(target.m_269291_().m_269075_(player), 3.0f + (float)upgrades * 0.5f);
                living.m_6862_(true);
            }
            target.m_6853_(false);
            target.f_19862_ = false;
            target.f_19863_ = false;
            target.m_20256_(target.m_20184_().m_82549_(lookVec.m_82490_(1.0 + (double)upgrades * 0.5)).m_82520_(0.0, (double)upgrades * 0.1, 0.0));
        }
        player.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)ModSounds.PUNCH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        NetworkHandler.sendToAllTracking((Object)new PacketSetEntityMotion(target, target.m_20184_()), target);
        NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle((ParticleOptions)ParticleTypes.f_123813_, target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0, 0.0, 0.0), target);
        CommonArmorHandler.getHandlerForPlayer(player).addAir(EquipmentSlot.FEET, -150 * upgrades);
    }
}

