/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateTextfield {
    private final int textFieldID;
    private final String text;

    public PacketUpdateTextfield(BlockEntity te, int textfieldID) {
        this.textFieldID = textfieldID;
        this.text = ((IGUITextFieldSensitive)te).getText(textfieldID);
    }

    public PacketUpdateTextfield(FriendlyByteBuf buffer) {
        this.textFieldID = buffer.readInt();
        this.text = buffer.m_130136_(Short.MAX_VALUE);
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.textFieldID);
        buffer.m_130070_(this.text);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketUtil.getBlockEntity((Player)((NetworkEvent.Context)ctx.get()).getSender(), BlockEntity.class).ifPresent(te -> {
            if (te instanceof IGUITextFieldSensitive) {
                ((IGUITextFieldSensitive)te).setText(this.textFieldID, this.text);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

