/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.psi;

import com.railwayteam.railways.mixin_interfaces.IContraptionFuel;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class PortableFuelInterfaceBlockEntity
extends PortableStorageInterfaceBlockEntity {
    protected LazyOptional<IFluidHandler> capability = this.createEmptyHandler();

    public PortableFuelInterfaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void startTransferringTo(Contraption contraption, float distance) {
        LazyOptional<IFluidHandler> oldcap = this.capability;
        this.capability = LazyOptional.of(() -> {
            MountedFluidStorageWrapper fuels = ((IContraptionFuel)contraption).railways$getFluidFuels();
            return new InterfaceFluidHandler((IFluidHandler)(fuels != null ? fuels : new FluidTank(0)));
        });
        oldcap.invalidate();
        super.startTransferringTo(contraption, distance);
    }

    protected void invalidateCapability() {
        this.capability.invalidate();
    }

    protected void stopTransferring() {
        LazyOptional<IFluidHandler> oldcap = this.capability;
        this.capability = this.createEmptyHandler();
        oldcap.invalidate();
        super.stopTransferring();
    }

    private LazyOptional<IFluidHandler> createEmptyHandler() {
        return LazyOptional.of(() -> new InterfaceFluidHandler((IFluidHandler)new FluidTank(0)));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isFluidHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public class InterfaceFluidHandler
    implements IFluidHandler {
        private IFluidHandler wrapped;

        public InterfaceFluidHandler(IFluidHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getTanks() {
            return this.wrapped.getTanks();
        }

        public FluidStack getFluidInTank(int tank) {
            return this.wrapped.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.wrapped.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.wrapped.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isConnected()) {
                return 0;
            }
            int fill = this.wrapped.fill(resource, action);
            if (fill > 0 && action.execute()) {
                this.keepAlive();
            }
            return fill;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!PortableFuelInterfaceBlockEntity.this.canTransfer()) {
                return FluidStack.EMPTY;
            }
            FluidStack drain = this.wrapped.drain(resource, action);
            if (!drain.isEmpty() && action.execute()) {
                this.keepAlive();
            }
            return drain;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!PortableFuelInterfaceBlockEntity.this.canTransfer()) {
                return FluidStack.EMPTY;
            }
            FluidStack drain = this.wrapped.drain(maxDrain, action);
            if (!drain.isEmpty() && action.execute()) {
                this.keepAlive();
            }
            return drain;
        }

        public void keepAlive() {
            PortableFuelInterfaceBlockEntity.this.onContentTransferred();
        }

        boolean isConnected() {
            int timeUnit = PortableFuelInterfaceBlockEntity.this.getTransferTimeout();
            return PortableFuelInterfaceBlockEntity.this.transferTimer >= 4 && PortableFuelInterfaceBlockEntity.this.transferTimer <= timeUnit + 4;
        }
    }
}

