/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.fences;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;

public class Fences {
    public static final String modid = "mcwfences";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Fences.setRegistrationWoodModLoaded(set, block, item, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_));
    }

    public static void setRegistrationHedges(List<String> leaves, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Fences.setRegistrationHedgesModLoaded(leaves, block, item, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_));
    }

    public static void setRegistrationRock(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Fences.setRegistrationRockModLoaded(rock, block, item, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50064_));
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.FENCES_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("FenceBlock")) {
                    CreateBlockReferences.createBlock(id, () -> new FenceBlock(WOOD), block, item);
                    continue;
                }
                if (blockId.reflectedLocation().contains("FenceGateBlock")) {
                    CreateBlockReferences.createBlock(id, () -> new FenceGateBlock(WOOD, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item);
                    continue;
                }
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new FenceBlock(WOOD), block, item);
            }
        }
    }

    public static void setRegistrationHedgesModLoaded(List<String> leaves, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties HEDGES = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : leaves) {
            for (BlockId blockId : McwBlocksIdBase.FENCES_LEAVE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), HEDGES), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new FenceBlock(HEDGES), block, item);
            }
        }
    }

    public static void setRegistrationRockModLoaded(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : rock) {
            for (BlockId blockId : McwBlocksIdBase.FENCES_STONE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("FenceBlock")) {
                    CreateBlockReferences.createBlockStone(id, () -> new FenceBlock(STONE), block, item);
                    continue;
                }
                if (blockId.reflectedLocation().contains("FenceGateBlock")) {
                    CreateBlockReferences.createBlockStone(id, () -> new FenceGateBlock(STONE, SoundEvents.f_11872_, SoundEvents.f_11873_), block, item);
                    continue;
                }
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, () -> new FenceBlock(STONE), block, item);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        Fences.addToTabModLoaded(event, MODID, WOOD, tab, "minecraft");
    }

    @Deprecated(forRemoval=true)
    public static void addToTabModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : WOOD) {
                Block picket_fence = Finder.findBlock(MODID, i + "_picket_fence");
                Block stockade_fence = Finder.findBlock(MODID, i + "_stockade_fence");
                Block horse_fence = Finder.findBlock(MODID, i + "_horse_fence");
                Block wired_fence = Finder.findBlock(MODID, i + "_wired_fence");
                Block highley_gate = Finder.findBlock(MODID, i + "_highley_gate");
                Block pyramid_gate = Finder.findBlock(MODID, i + "_pyramid_gate");
                Block curved_gate = Finder.findBlock(MODID, i + "_curved_gate");
                event.m_246326_((ItemLike)picket_fence);
                event.m_246326_((ItemLike)stockade_fence);
                event.m_246326_((ItemLike)horse_fence);
                event.m_246326_((ItemLike)wired_fence);
                event.m_246326_((ItemLike)highley_gate);
                event.m_246326_((ItemLike)pyramid_gate);
                event.m_246326_((ItemLike)curved_gate);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTabHedge(BuildCreativeModeTabContentsEvent event, String MODID, List<String> LEAVES, CreativeModeTab tab) {
        Fences.addToTabHedgeModLoaded(event, MODID, LEAVES, tab, "minecraft");
    }

    @Deprecated(forRemoval=true)
    public static void addToTabHedgeModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> LEAVES, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : LEAVES) {
                Block hedge = Finder.findBlock(MODID, i + "_hedge");
                event.m_246326_((ItemLike)hedge);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTabStone(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab) {
        Fences.addToTabStoneModLoaded(event, MODID, STONE, tab, "minecraft");
    }

    @Deprecated(forRemoval=true)
    public static void addToTabStoneModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : STONE) {
                Block modern_wall = Finder.findBlock(MODID, "modern_" + i + "_wall");
                Block railing_wall = Finder.findBlock(MODID, "railing_" + i + "_wall");
                Block railing_gate = Finder.findBlock(MODID, i + "_railing_gate");
                Block pillar_wall = Finder.findBlock(MODID, i + "_pillar_wall");
                Block grass_topped_wall = Finder.findBlock(MODID, i + "_grass_topped_wall");
                event.m_246326_((ItemLike)modern_wall);
                event.m_246326_((ItemLike)railing_wall);
                event.m_246326_((ItemLike)railing_gate);
                event.m_246326_((ItemLike)pillar_wall);
                event.m_246326_((ItemLike)grass_topped_wall);
            }
        }
    }
}

