/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public final class ColorHelper {
    private ColorHelper() {
    }

    public static int getColorFrom(ResourceLocation location) {
        TextureAtlas textureMap = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
        TextureAtlasSprite sprite = textureMap.m_118316_(location);
        return ColorHelper.getColorFrom(sprite);
    }

    public static int getColorFrom(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return -1;
        }
        int[][] pixelMatrix = new int[][]{{0}};
        int total = 0;
        int red = 0;
        int blue = 0;
        int green = 0;
        for (int pixel : pixelMatrix[pixelMatrix.length - 1]) {
            Color color = new Color(pixel);
            if (color.getAlpha() < 255) continue;
            ++total;
            red += color.getRed();
            green += color.getGreen();
            blue += color.getBlue();
        }
        if (total > 0) {
            return new Color(red / total, green / total, blue / total, 255).getRGB();
        }
        return -1;
    }

    public static int getColorFrom(TextureAtlasSprite sprite, Color filter) {
        if (sprite == null) {
            return -1;
        }
        int[][] pixelMatrix = new int[][]{{0}};
        int total = 0;
        int red = 0;
        int blue = 0;
        int green = 0;
        for (int pixel : pixelMatrix[pixelMatrix.length - 1]) {
            Color color = new Color(pixel);
            if (color.getAlpha() < 255 || color.getRGB() - filter.getRGB() < 100 && color.getRGB() - filter.getRGB() > 100) continue;
            ++total;
            red += color.getRed();
            green += color.getGreen();
            blue += color.getBlue();
        }
        if (total > 0) {
            return new Color(red / total, green / total, blue / total, 255).brighter().getRGB();
        }
        return -1;
    }
}

