/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.lighting.LightModel;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mrtjp.projectred.core.client.HaloRenderer;
import mrtjp.projectred.illumination.item.MultipartLightPartItem;
import mrtjp.projectred.illumination.part.MultipartLightPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;

public abstract class MultipartLightProperties {
    public boolean canFloat() {
        return false;
    }

    public abstract ItemStack makeStack(int var1, boolean var2);

    public abstract VoxelShape getShape(int var1);

    public abstract Cuboid6 getBounds(int var1);

    public abstract Cuboid6 getGlowBounds(int var1);

    public abstract MultipartLightPart partFactory(int var1, boolean var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onTextureStitchEvent(TextureStitchEvent.Post var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract TextureAtlasSprite getIcon(int var1);

    public abstract CCModel getBulbModel(int var1);

    public abstract CCModel getChasisModel(int var1);

    public CCModel getInventoryBulbModel() {
        return this.getBulbModel(0);
    }

    public CCModel getInventoryChassisModel() {
        return this.getChasisModel(0);
    }

    public Cuboid6 getInventoryGlowBounds() {
        return this.getGlowBounds(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MultipartLightPart part, Vector3 pos, CCRenderState ccrs) {
        IconTransformation icon = new IconTransformation(this.getIcon(part.getColor()));
        Translation t = pos.translation();
        this.getChasisModel(part.getSide()).render(ccrs, new IVertexOperation[]{t, icon});
        this.getBulbModel(part.getSide()).render(ccrs, new IVertexOperation[]{t, icon, this.getColourMultiplier(part.getColor(), part.isLightOn())});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventory(int colour, boolean inverted, Vector3 pos, CCRenderState ccrs) {
        IconTransformation icon = new IconTransformation(this.getIcon(colour));
        Translation t = pos.translation();
        this.getInventoryChassisModel().render(ccrs, new IVertexOperation[]{t, icon});
        this.getInventoryBulbModel().render(ccrs, new IVertexOperation[]{t, icon, this.getColourMultiplier(colour, inverted)});
    }

    public ColourMultiplier getColourMultiplier(int color, boolean isOn) {
        ColourRGBA c = EnumColour.values()[color].getColour();
        if (!isOn) {
            c.multiply((Colour)EnumColour.GRAY.getColour());
        }
        return new ColourMultiplier(c.rgba());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Class<? extends IItemRenderer> getItemRendererClass() {
        return DefaultMultipartLightItemRenderer.class;
    }

    public static VoxelShape[] boxesToShapes(Cuboid6[] bounds) {
        return (VoxelShape[])Arrays.stream(bounds).map(VoxelShapeCache::getShape).toArray(VoxelShape[]::new);
    }

    public static Map<String, CCModel> parseCorrectedModel(String name) {
        Map models = new OBJParser(new ResourceLocation("projectred_illumination", "obj/" + name + ".obj")).ignoreMtl().quads().parse();
        HashMap<String, CCModel> bfModels = new HashMap<String, CCModel>();
        models.forEach((key, model) -> bfModels.put((String)key, model.backfacedCopy()));
        Translation t = new Translation(0.5, 0.0, 0.5);
        for (CCModel model2 : bfModels.values()) {
            model2.apply((Transformation)t);
        }
        return bfModels;
    }

    public static CCModel bakeCopy(int s, CCModel model) {
        CCModel m = model.copy();
        m.apply(Rotation.sideOrientation((int)s, (int)0).at(Vector3.CENTER));
        MultipartLightProperties.finishModel(m);
        return m;
    }

    public static CCModel finishModel(CCModel model) {
        model.computeNormals();
        model.computeLighting(LightModel.standardLightModel);
        model.shrinkUVs(5.0E-4);
        return model;
    }

    public static Cuboid6[] sidedBoxes(Cuboid6 box) {
        Cuboid6[] boxes = new Cuboid6[6];
        boxes[0] = box.copy();
        for (int s = 1; s < 6; ++s) {
            boxes[s] = box.copy().apply(Rotation.sideRotations[s].at(Vector3.CENTER));
        }
        return boxes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class DefaultMultipartLightItemRenderer
    implements IItemRenderer {
        public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
            Item item = stack.m_41720_();
            if (!(item instanceof MultipartLightPartItem)) {
                return;
            }
            MultipartLightPartItem lightItem = (MultipartLightPartItem)item;
            MultipartLightProperties props = lightItem.getLightProperties();
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.brightness = packedLight;
            ccrs.overlay = packedOverlay;
            ccrs.bind(RenderType.m_110463_(), getter, mStack);
            props.renderInventory(lightItem.getColor(), lightItem.isInverted(), Vector3.ZERO, ccrs);
            if (lightItem.isInverted()) {
                HaloRenderer.renderInventoryHalo((CCRenderState)ccrs, (PoseStack)mStack, (MultiBufferSource)getter, (Cuboid6)props.getInventoryGlowBounds(), (Vector3)Vector3.ZERO, (int)lightItem.getColor());
                HaloRenderer.addItemRendererBloom((ItemDisplayContext)transformType, (PoseStack)mStack, (Vector3)Vector3.ZERO, (Cuboid6)props.getInventoryGlowBounds(), (int)lightItem.getColor());
            }
        }

        public PerspectiveModelState getModelState() {
            return TransformUtils.DEFAULT_BLOCK;
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }
    }
}

