/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.block;

import codechicken.multipart.api.RedstoneConnectorBlock;
import javax.annotation.Nullable;
import mrtjp.projectred.illumination.tile.IllumarLampBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class IllumarLampBlock
extends Block
implements EntityBlock,
RedstoneConnectorBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    private final int color;
    private final boolean inverted;

    public IllumarLampBlock(int color, boolean inverted) {
        super(BlockBehaviour.Properties.m_284310_().m_284495_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? MapColor.m_284175_((int)(MapColor.f_283919_.f_283805_ + color)) : MapColor.f_283818_).m_60918_(SoundType.f_56744_).m_60978_(0.5f).m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0));
        this.color = color;
        this.inverted = inverted;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(inverted)));
    }

    public int getColor() {
        return this.color;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_()) != this.inverted));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos neighbor, boolean isMoving) {
        boolean shouldBeLit;
        super.onNeighborChange(state, (LevelReader)world, pos, neighbor);
        if (world.m_5776_()) {
            return;
        }
        boolean isLit = (Boolean)state.m_61143_((Property)LIT);
        boolean bl = shouldBeLit = world.m_276867_(pos) != this.inverted;
        if (isLit != shouldBeLit && !world.m_183326_().m_183582_(pos, (Object)this)) {
            world.m_186460_(pos, (Block)this, 2);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        boolean shouldBeLit;
        super.m_213897_(state, world, pos, rand);
        boolean isLit = (Boolean)state.m_61143_((Property)LIT);
        boolean bl = shouldBeLit = world.m_276867_(pos) != this.inverted;
        if (isLit != shouldBeLit) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(shouldBeLit)));
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new IllumarLampBlockEntity(this.color, this.inverted, pos, state);
    }

    public int getConnectionMask(LevelReader world, BlockPos pos, int side) {
        return 31;
    }

    public int weakPowerLevel(LevelReader world, BlockPos pos, int side, int mask) {
        return 0;
    }
}

