/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.init;

import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.part.render.PartRenderer;
import java.util.Objects;
import mrtjp.projectred.illumination.BlockLightType;
import mrtjp.projectred.illumination.MultipartLightType;
import mrtjp.projectred.illumination.client.IllumarLampBlockEntityRenderer;
import mrtjp.projectred.illumination.client.IllumarLampItemRenderer;
import mrtjp.projectred.illumination.client.IllumarSmartLampBlockEntityRenderer;
import mrtjp.projectred.illumination.client.IllumarSmartLampItemRenderer;
import mrtjp.projectred.illumination.client.MultipartLightPartRenderer;
import mrtjp.projectred.illumination.init.IlluminationBlocks;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class IlluminationClientInit {
    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(IlluminationClientInit::clientSetup);
        modEventBus.addListener(IlluminationClientInit::onModelBake);
        for (MultipartLightType type : MultipartLightType.values()) {
            modEventBus.addListener(type.getProperties()::onTextureStitchEvent);
        }
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        for (BlockLightType blockLightType : BlockLightType.values()) {
            for (int color = 0; color < 16; ++color) {
                BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)SneakyUtils.unsafeCast(blockLightType.getTileEntityType(color, false))), c -> IllumarLampBlockEntityRenderer.INSTANCE);
                BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)SneakyUtils.unsafeCast(blockLightType.getTileEntityType(color, true))), c -> IllumarLampBlockEntityRenderer.INSTANCE);
            }
        }
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)SneakyUtils.unsafeCast((Object)IlluminationBlocks.ILLUMAR_SMART_LAMP_BLOCK_ENTITY.get())), c -> IllumarSmartLampBlockEntityRenderer.INSTANCE);
        for (Enum enum_ : MultipartLightType.values()) {
            for (int colour = 0; colour < 16; ++colour) {
                MultipartClientRegistry.register(((MultipartLightType)enum_).getPartType(colour, false), (PartRenderer)MultipartLightPartRenderer.INSTANCE);
                MultipartClientRegistry.register(((MultipartLightType)enum_).getPartType(colour, true), (PartRenderer)MultipartLightPartRenderer.INSTANCE);
            }
        }
    }

    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        for (int color = 0; color < 16; ++color) {
            ResourceLocation blockRL = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)BlockLightType.ILLUMAR_LAMP.getBlock(color, true)));
            BakedModel litModel = (BakedModel)event.getModels().get(new ModelResourceLocation(blockRL, "lit=true"));
            event.getModels().put(new ModelResourceLocation(blockRL, "inventory"), new IllumarLampItemRenderer(litModel));
        }
        ResourceLocation smartLampRl = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)IlluminationBlocks.ILLUMAR_SMART_LAMP.get())));
        BakedModel smartLampModel = (BakedModel)event.getModels().get(new ModelResourceLocation(smartLampRl, "level=15,side=0"));
        event.getModels().put(new ModelResourceLocation(smartLampRl, "inventory"), new IllumarSmartLampItemRenderer(smartLampModel));
    }
}

