/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.part;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Cuboid6;
import java.util.Map;
import javax.annotation.Nullable;
import mrtjp.projectred.illumination.MultipartLightProperties;
import mrtjp.projectred.illumination.MultipartLightType;
import mrtjp.projectred.illumination.part.MultipartLightFacePart;
import mrtjp.projectred.illumination.part.MultipartLightPart;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;

public class FixtureLightProperties
extends MultipartLightProperties {
    private static final Cuboid6[] BOUNDS = FixtureLightProperties.sidedBoxes(new Cuboid6(0.21875, 0.0, 0.21875, 0.78125, 0.40625, 0.78125));
    private static final Cuboid6[] GLOW_BOUNDS = FixtureLightProperties.sidedBoxes(new Cuboid6(0.25, 0.09375, 0.25, 0.75, 0.40625, 0.75));
    private static final VoxelShape[] SHAPES = FixtureLightProperties.boxesToShapes(BOUNDS);
    @Nullable
    private TextureAtlasSprite icon;

    @Override
    public VoxelShape getShape(int side) {
        return SHAPES[side];
    }

    @Override
    public ItemStack makeStack(int color, boolean inverted) {
        return MultipartLightType.FIXTURE.makeStack(color, inverted);
    }

    @Override
    public MultipartLightPart partFactory(int color, boolean inverted) {
        return new MultipartLightFacePart(MultipartLightType.FIXTURE.getPartType(color, inverted), this, color, inverted);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTextureStitchEvent(TextureStitchEvent.Post event) {
        if (!event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        this.icon = event.getAtlas().m_118316_(new ResourceLocation("projectred_illumination", "block/fixture"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getIcon(int color) {
        assert (this.icon != null);
        return this.icon;
    }

    @Override
    public Cuboid6 getGlowBounds(int side) {
        return GLOW_BOUNDS[side];
    }

    @Override
    public Cuboid6 getBounds(int side) {
        return BOUNDS[side];
    }

    @Override
    public CCModel getBulbModel(int side) {
        return FixtureLightModels.BULB_MODELS[side];
    }

    @Override
    public CCModel getChasisModel(int side) {
        return FixtureLightModels.CHASSIS_MODELS[side];
    }

    private static class FixtureLightModels {
        private static final CCModel[] BULB_MODELS = new CCModel[6];
        private static final CCModel[] CHASSIS_MODELS = new CCModel[6];

        private FixtureLightModels() {
        }

        static {
            Map<String, CCModel> models = MultipartLightProperties.parseCorrectedModel("fixture");
            CCModel chassis = models.get("chassi");
            CCModel bulb = models.get("bulb");
            for (int s = 0; s < 6; ++s) {
                FixtureLightModels.BULB_MODELS[s] = MultipartLightProperties.bakeCopy(s, bulb);
                FixtureLightModels.CHASSIS_MODELS[s] = MultipartLightProperties.bakeCopy(s, chassis);
            }
        }
    }
}

