/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Rotation;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.api.IMaskedBundledTile;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.core.FaceLookup;
import mrtjp.projectred.core.tile.BaseConnectableBlockEntity;
import mrtjp.projectred.core.tile.IOrientableBlockEntity;
import mrtjp.projectred.illumination.block.IllumarSmartLampBlock;
import mrtjp.projectred.illumination.init.IlluminationBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class IllumarSmartLampBlockEntity
extends BaseConnectableBlockEntity
implements IOrientableBlockEntity,
IMaskedBundledTile {
    private static final int PACKET_SIGNAL = 10;
    private final byte[] signal = new byte[16];

    public IllumarSmartLampBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IlluminationBlocks.ILLUMAR_SMART_LAMP_BLOCK_ENTITY.get(), pos, state);
    }

    public byte[] getSignal() {
        return this.signal;
    }

    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        tag.m_128382_("signal", this.signal);
    }

    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        byte[] s = tag.m_128463_("signal");
        if (s.length == 16) {
            System.arraycopy(s, 0, this.signal, 0, 16);
        }
    }

    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
        for (int i = 0; i < 16; ++i) {
            out.writeByte((int)this.signal[i]);
        }
    }

    public void readDesc(MCDataInput in) {
        super.readDesc(in);
        for (int i = 0; i < 16; ++i) {
            this.signal[i] = in.readByte();
        }
    }

    public void receiveUpdateFromServer(int key, MCDataInput input) {
        switch (key) {
            case 10: {
                this.readSignalUpdate(input);
                break;
            }
            default: {
                super.receiveUpdateFromServer(key, input);
            }
        }
    }

    private void readSignalUpdate(MCDataInput input) {
        short changeMask = input.readShort();
        for (int i = 0; i < 16; ++i) {
            if ((changeMask & 1 << i) == 0) continue;
            this.signal[i] = input.readByte();
        }
    }

    private void sendSignalUpdate(int changeMask) {
        if (changeMask == 0) {
            return;
        }
        this.sendUpdateToPlayersWatchingChunk(10, stream -> {
            stream.writeShort(changeMask);
            for (int i = 0; i < 16; ++i) {
                if ((changeMask & 1 << i) == 0) continue;
                stream.writeByte((int)this.signal[i]);
            }
        });
    }

    public BlockState storeBlockState(BlockState defaultState) {
        int max = 0;
        for (byte b : this.signal) {
            max = Math.max(max, b & 0xFF);
        }
        return (BlockState)super.storeBlockState(defaultState).m_61124_((Property)IllumarSmartLampBlock.LEVEL, (Comparable)Integer.valueOf(max / 17));
    }

    public byte[] getBundledSignal(int dir) {
        return null;
    }

    public boolean canConnectBundled(int side) {
        return side != (this.getSide() ^ 1);
    }

    public int getConnectionMask(int side) {
        if (side == this.getSide()) {
            return 31;
        }
        if (side == (this.getSide() ^ 1)) {
            return 0;
        }
        return 1 << Rotation.rotationTo((int)(side ^ 1), (int)this.getSide());
    }

    public boolean canConnectPart(IConnectable part, int s, int edgeRot) {
        if (!(part instanceof IBundledEmitter)) {
            return false;
        }
        int side = this.getSide();
        if (s == side) {
            return true;
        }
        if (s == (side ^ 1)) {
            return false;
        }
        return edgeRot == Rotation.rotationTo((int)(s ^ 1), (int)side);
    }

    public void onNeighborBlockChanged(BlockPos neighborPos) {
        super.onNeighborBlockChanged(neighborPos);
        if (!this.m_58904_().f_46443_) {
            this.checkSignal();
        }
    }

    public void onBlockPlaced(@Nullable LivingEntity player, ItemStack item) {
        super.onBlockPlaced(player, item);
        if (!this.m_58904_().f_46443_) {
            this.checkSignal();
        }
    }

    public void onOrientationChange() {
        if (!this.m_58904_().f_46443_) {
            this.updateExternals();
            this.notifyExternals(15);
            this.checkSignal();
        }
    }

    private void checkSignal() {
        byte[] newSig = this.calcBundledInput();
        int changeMask = BundledSignalsLib.applyAndGetChangeMask((byte[])newSig, (byte[])this.signal);
        if (changeMask != 0) {
            this.pushBlockState();
            this.sendSignalUpdate(changeMask);
        }
    }

    protected byte[] calcBundledInput() {
        byte[] newSignal = new byte[16];
        for (int s = 0; s < 6; ++s) {
            int r;
            if (s == (this.getSide() ^ 1)) continue;
            if (s == this.getSide()) {
                if (this.maskConnectsStraightCenter(s)) {
                    BundledSignalsLib.raiseSignal((byte[])newSignal, (byte[])this.calcCenterSignal(s));
                }
                for (r = 0; r < 4; ++r) {
                    if (this.maskConnectsStraight(s, r)) {
                        BundledSignalsLib.raiseSignal((byte[])newSignal, (byte[])this.calcStraightSignal(s, r));
                        continue;
                    }
                    if (!this.maskConnectsCorner(s, r)) continue;
                    BundledSignalsLib.raiseSignal((byte[])newSignal, (byte[])this.calcCornerSignal(s, r));
                }
                continue;
            }
            r = Rotation.rotationTo((int)(s ^ 1), (int)this.getSide());
            if (this.maskConnectsStraight(s, r)) {
                BundledSignalsLib.raiseSignal((byte[])newSignal, (byte[])this.calcStraightSignal(s, r));
                continue;
            }
            if (!this.maskConnectsCorner(s, r)) continue;
            BundledSignalsLib.raiseSignal((byte[])newSignal, (byte[])this.calcCornerSignal(s, r));
        }
        return newSignal;
    }

    @Nullable
    private byte[] calcCornerSignal(int s, int r) {
        int vs = Rotation.rotateSide((int)(s ^ 1), (int)r);
        int vr = Rotation.rotationTo((int)vs, (int)s);
        FaceLookup lookup = FaceLookup.lookupCorner((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (int)vs, (int)vr);
        return this.resolveArray(lookup);
    }

    @Nullable
    private byte[] calcStraightSignal(int s, int r) {
        int vs = Rotation.rotateSide((int)(s ^ 1), (int)r);
        int vr = Rotation.rotationTo((int)vs, (int)s);
        FaceLookup lookup = FaceLookup.lookupStraight((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (int)vs, (int)vr);
        return this.resolveArray(lookup);
    }

    @Nullable
    private byte[] calcCenterSignal(int s) {
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (int)s);
        return this.resolveArray(lookup);
    }

    @Nullable
    protected byte[] resolveArray(FaceLookup lookup) {
        if (lookup.part instanceof IBundledEmitter) {
            return ((IBundledEmitter)lookup.part).getBundledSignal(lookup.otherRotation);
        }
        if (lookup.tile instanceof IBundledTile) {
            return ((IBundledTile)lookup.tile).getBundledSignal(Rotation.rotateSide((int)lookup.otherSide, (int)lookup.otherRotation));
        }
        if (lookup.tile != null) {
            return BundledSignalsLib.getBundledSignalViaInteraction((Level)Objects.requireNonNull(lookup.tile.m_58904_()), (BlockPos)lookup.tile.m_58899_(), (Direction)Direction.values()[Rotation.rotateSide((int)lookup.otherSide, (int)lookup.otherRotation)]);
        }
        return null;
    }

    @Nullable
    protected byte[] resolveArray(CenterLookup lookup) {
        if (lookup.part instanceof IBundledEmitter) {
            return ((IBundledEmitter)lookup.part).getBundledSignal(lookup.otherDirection);
        }
        if (lookup.tile instanceof IBundledTile) {
            return ((IBundledTile)lookup.tile).getBundledSignal(lookup.otherDirection);
        }
        if (lookup.tile != null) {
            return BundledSignalsLib.getBundledSignalViaInteraction((Level)Objects.requireNonNull(lookup.tile.m_58904_()), (BlockPos)lookup.tile.m_58899_(), (Direction)Direction.values()[lookup.otherDirection]);
        }
        return null;
    }
}

