/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.criteria;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.logging.log4j.Logger;

public class SafeStructureLocationPredicate {
    private final ResourceKey<Structure> configuredStructureFeature;

    public SafeStructureLocationPredicate(ResourceKey<Structure> configuredStructureFeature) {
        this.configuredStructureFeature = configuredStructureFeature;
    }

    public boolean matches(ServerLevel serverLevel, double x, double y, double z) {
        return this.matches(serverLevel, (float)x, (float)y, (float)z);
    }

    public boolean matches(ServerLevel serverLevel, float x, float y, float z) {
        BlockPos blockpos = new BlockPos((int)x, (int)y, (int)z);
        return this.configuredStructureFeature != null && serverLevel.m_46749_(blockpos) && serverLevel.m_215010_().m_220488_(blockpos, this.configuredStructureFeature).m_73603_();
    }

    public JsonElement serializeToJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.configuredStructureFeature != null) {
            jsonObject.addProperty("feature", this.configuredStructureFeature.m_135782_().toString());
        }
        return jsonObject;
    }

    public static SafeStructureLocationPredicate fromJson(JsonElement jsonElement) {
        if (jsonElement != null && !jsonElement.isJsonNull()) {
            JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"location");
            ResourceKey featureResourceKey = jsonObject.has("feature") ? (ResourceKey)ResourceLocation.f_135803_.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("feature")).resultOrPartial(arg_0 -> ((Logger)YungsApiCommon.LOGGER).error(arg_0)).map(resourceLocation -> ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)resourceLocation)).orElse(null) : null;
            return new SafeStructureLocationPredicate(featureResourceKey);
        }
        return new SafeStructureLocationPredicate(null);
    }
}

