/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility;

import com.copycatsplus.copycats.foundation.copycat.CopycatExternalContext;
import com.copycatsplus.copycats.foundation.copycat.model.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.mixin.copycat.VoxelShapeAccessor;
import com.copycatsplus.copycats.utility.MathUtils;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFaceUtils {
    private static final ThreadLocal<Map<BiFunction<VoxelShape, VoxelShape, Boolean>, Object2ByteLinkedOpenHashMap<ShapeKey>>> SHAPE_OP_CACHE = ThreadLocal.withInitial(HashMap::new);

    private static boolean invokeCachedOperation(BiFunction<VoxelShape, VoxelShape, Boolean> operation, VoxelShape fromShape, VoxelShape toShape) {
        ShapeKey key;
        Object2ByteLinkedOpenHashMap cache = SHAPE_OP_CACHE.get().computeIfAbsent(operation, op -> {
            Object2ByteLinkedOpenHashMap<ShapeKey> cacheMap = new Object2ByteLinkedOpenHashMap<ShapeKey>(2048, 0.25f){

                protected void rehash(int i) {
                }
            };
            cacheMap.defaultReturnValue((byte)127);
            return cacheMap;
        });
        byte result = cache.getAndMoveToFirst((Object)(key = new ShapeKey(fromShape, toShape)));
        if (result == 127) {
            boolean value = operation.apply(fromShape, toShape);
            if (cache.size() >= 2048) {
                cache.removeLastByte();
            }
            cache.putAndMoveToFirst((Object)key, (byte)(value ? 1 : 0));
            return value;
        }
        return result == 1;
    }

    private static boolean processBlockFace(BlockGetter level, BlockState fromState, BlockPos fromPos, BlockState toState, BlockPos toPos, Direction fromFace, BiFunction<VoxelShape, VoxelShape, Boolean> operation) {
        VoxelShape fromShape = null;
        Vec3i scale = new Vec3i(1, 1, 1);
        Vec3i inner = new Vec3i(0, 0, 0);
        BlockPos truePos = fromPos;
        if (level instanceof ScaledBlockAndTintGetter) {
            IMultiStateCopycatBlock copycatBlock;
            ScaledBlockAndTintGetter scaledWorld = (ScaledBlockAndTintGetter)level;
            scale = scaledWorld.getScale();
            truePos = scaledWorld.getTruePos(fromPos);
            Block block = fromState.m_60734_();
            if (block instanceof IMultiStateCopycatBlock && (copycatBlock = (IMultiStateCopycatBlock)block).vectorScale(fromState).equals((Object)scaledWorld.getScale())) {
                String property = scaledWorld.getPropertyForRender(fromState, fromPos);
                if (!copycatBlock.partExists(fromState, property)) {
                    return false;
                }
                inner = copycatBlock.getVectorFromProperty(fromState, property);
                fromShape = copycatBlock.getPartialFaceShape((BlockGetter)scaledWorld, fromState, property, fromFace);
            }
        }
        if (fromShape == null) {
            fromShape = fromState.m_60655_(level, fromPos, fromFace);
        }
        if (fromShape.m_83281_()) {
            return false;
        }
        VoxelShape toShape = null;
        List<Object> potentialParts = null;
        Block block = toState.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            Vec3i toScale = copycatBlock.vectorScale(toState);
            Direction.Axis connectingAxis = fromFace.m_122434_();
            BlockGetter world = level;
            BlockPos toTruePos = toPos;
            String fallbackProperty = copycatBlock.defaultProperty();
            if (level instanceof ScaledBlockAndTintGetter) {
                ScaledBlockAndTintGetter scaledWorld = (ScaledBlockAndTintGetter)level;
                world = scaledWorld.getWrapped();
                toTruePos = scaledWorld.getTruePos(toPos);
                fallbackProperty = scaledWorld.getRenderingProperty();
                if (toTruePos.equals((Object)truePos)) {
                    potentialParts = List.of(scaledWorld.getPropertyForRender(toState, toPos));
                }
            }
            if (potentialParts == null) {
                if (MathUtils.replaceAxis(scale, connectingAxis, 0).equals((Object)MathUtils.replaceAxis(toScale, connectingAxis, 0))) {
                    potentialParts = List.of(copycatBlock.getPropertyFromRender(fallbackProperty, toState, world, MathUtils.replaceAxis(inner, connectingAxis, fromFace.m_122421_() == Direction.AxisDirection.POSITIVE ? 0 : toScale.m_123304_(connectingAxis) - 1), toTruePos));
                } else {
                    potentialParts = new ArrayList(4);
                    int connectingPart = fromFace.m_122421_() == Direction.AxisDirection.POSITIVE ? 0 : toScale.m_123304_(connectingAxis) - 1;
                    Direction.Axis axis = switch (connectingAxis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> Direction.Axis.Y;
                        case Direction.Axis.Y -> Direction.Axis.Z;
                        case Direction.Axis.Z -> Direction.Axis.X;
                    };
                    Direction.Axis axis2 = switch (connectingAxis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> Direction.Axis.Z;
                        case Direction.Axis.Y -> Direction.Axis.X;
                        case Direction.Axis.Z -> Direction.Axis.Y;
                    };
                    for (int i = 0; i < toScale.m_123304_(axis); ++i) {
                        for (int j = 0; j < toScale.m_123304_(axis2); ++j) {
                            potentialParts.add(copycatBlock.getPropertyFromRender(fallbackProperty, toState, world, MathUtils.replaceAxis(MathUtils.replaceAxis(new Vec3i(connectingPart, connectingPart, connectingPart), axis, i), axis2, j), toTruePos));
                        }
                    }
                }
            }
            for (String string : potentialParts) {
                toShape = copycatBlock.getPartialFaceShape(world, toState, string, fromFace.m_122424_());
                if (!BlockFaceUtils.invokeCachedOperation(operation, fromShape, toShape)) continue;
                String property = CopycatExternalContext.getPropertyForAppearance();
                if (property == null) {
                    property = copycatBlock.defaultProperty();
                }
                CopycatExternalContext.setPropertyForAppearance(copycatBlock.getPropertyFromRender(property, toState, world, copycatBlock.getVectorFromProperty(toState, string), toTruePos));
                return true;
            }
        }
        if (toShape == null) {
            toShape = toState.m_60655_(level, toPos, fromFace.m_122424_());
        }
        CopycatExternalContext.setPropertyForAppearance(null);
        return BlockFaceUtils.invokeCachedOperation(operation, fromShape, toShape);
    }

    public static boolean canOcclude(BlockGetter level, BlockState occludedState, BlockPos occludedPos, BlockState occludingState, BlockPos occludingPos, Direction occludedFace) {
        return BlockFaceUtils.processBlockFace(level, occludedState, occludedPos, occludingState, occludingPos, occludedFace, (occluded, occluding) -> !Shapes.m_83157_((VoxelShape)occluded, (VoxelShape)occluding, (BooleanOp)BooleanOp.f_82685_));
    }

    public static boolean faceMatch(BlockGetter level, BlockState fromState, BlockPos fromPos, BlockState toState, BlockPos toPos, Direction fromFace) {
        return BlockFaceUtils.processBlockFace(level, fromState, fromPos, toState, toPos, fromFace, (from, to) -> !Shapes.m_83157_((VoxelShape)from, (VoxelShape)to, (BooleanOp)BooleanOp.f_82687_));
    }

    public static VoxelShape getPartialFaceShape(BlockGetter level, BlockState state, String property, Direction face) {
        IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)state.m_60734_();
        Vec3i scale = copycatBlock.vectorScale(state);
        Vec3i part = copycatBlock.getVectorFromProperty(state, property);
        return BlockFaceUtils.getPartialFaceShape(state.m_60768_(level, BlockPos.f_121853_), face, part, scale);
    }

    public static VoxelShape getPartialFaceShape(VoxelShape voxelShape, Direction direction, Vec3i part, Vec3i scale) {
        int i;
        Direction.Axis axis = direction.m_122434_();
        double startX = (double)part.m_123341_() / (double)scale.m_123341_();
        double startY = (double)part.m_123342_() / (double)scale.m_123342_();
        double startZ = (double)part.m_123343_() / (double)scale.m_123343_();
        double sizeX = 1.0 / (double)scale.m_123341_();
        double sizeY = 1.0 / (double)scale.m_123342_();
        double sizeZ = 1.0 / (double)scale.m_123343_();
        double endX = startX + sizeX;
        double endY = startY + sizeY;
        double endZ = startZ + sizeZ;
        VoxelShape bounds = Shapes.m_83048_((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
        voxelShape = Shapes.m_83148_((VoxelShape)voxelShape, (VoxelShape)bounds, (BooleanOp)BooleanOp.f_82689_);
        int axisSize = ((VoxelShapeAccessor)voxelShape).copycats$getShape().m_82850_(axis);
        boolean isEmpty = false;
        if (direction.m_122421_() == Direction.AxisDirection.POSITIVE) {
            double d = voxelShape.m_83297_(axis);
            isEmpty = DoubleMath.fuzzyCompare((double)d, (double)(switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> endX;
                case Direction.Axis.Y -> endY;
                case Direction.Axis.Z -> endZ;
            }), (double)1.0E-7) < 0;
            i = Mth.m_14107_((double)Mth.m_14008_((double)((double)axisSize * axis.m_6150_(endX, endY, endZ)), (double)-1.0, (double)axisSize)) - 1;
        } else {
            double d = voxelShape.m_83288_(axis);
            isEmpty = DoubleMath.fuzzyCompare((double)d, (double)(switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> startX;
                case Direction.Axis.Y -> startY;
                case Direction.Axis.Z -> startZ;
            }), (double)1.0E-7) > 0;
            i = Mth.m_14107_((double)Mth.m_14008_((double)((double)axisSize * axis.m_6150_(startX, startY, startZ)), (double)-1.0, (double)axisSize));
        }
        if (isEmpty) {
            return Shapes.m_83040_();
        }
        return new SliceShape(voxelShape, axis, i);
    }

    public record ShapeKey(VoxelShape fromShape, VoxelShape toShape) {
    }
}

