/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.part.face;

import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.part.StandardMicroFactory;
import codechicken.microblock.part.StandardMicroblockPart;
import codechicken.microblock.util.MaskedCuboid;
import codechicken.multipart.api.part.FacePart;
import java.util.List;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FaceMicroblockPart
extends StandardMicroblockPart
implements FacePart {
    public static final Cuboid6[] aBounds = new Cuboid6[256];
    public static final VoxelShape[] aShapes = new VoxelShape[256];

    public FaceMicroblockPart(MicroMaterial material) {
        super(material);
    }

    @Override
    public Cuboid6 getBounds() {
        return aBounds[this.shape];
    }

    @Override
    public VoxelShape getShape(CollisionContext context) {
        return aShapes[this.shape];
    }

    @Override
    public Iterable<MaskedCuboid> getRenderCuboids(boolean isInventory) {
        if (isInventory) {
            return List.of(new MaskedCuboid(this.getBounds(), 0));
        }
        if (this.isTransparent()) {
            return List.of(new MaskedCuboid(this.renderBounds, this.renderMask));
        }
        return List.of(new MaskedCuboid(this.renderBounds, this.renderMask | 1 << this.getSlot()), new MaskedCuboid(this.getBounds(), ~(1 << this.getSlot())));
    }

    @Override
    public StandardMicroFactory getMicroFactory() {
        return (StandardMicroFactory)CBMicroblockModContent.FACE_MICROBLOCK_PART.get();
    }

    static {
        for (int s = 0; s < 6; ++s) {
            Transformation transform = Rotation.sideRotations[s].at(Vector3.CENTER);
            for (int t = 1; t < 8; ++t) {
                double d = (double)t / 8.0;
                int i = t << 4 | s;
                FaceMicroblockPart.aBounds[i] = new Cuboid6(0.0, 0.0, 0.0, 1.0, d, 1.0).apply(transform);
                FaceMicroblockPart.aShapes[i] = VoxelShapeCache.getShape((Cuboid6)aBounds[i]);
            }
        }
    }
}

