/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.util;

import codechicken.microblock.api.MicroMaterial;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

public class MicroMaterialRegistry {
    private static final CrashLock LOCK = new CrashLock("Already initialized");
    public static IForgeRegistry<MicroMaterial> MICRO_MATERIALS;

    public static void init() {
        LOCK.lock();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(MicroMaterialRegistry::createRegistries);
    }

    private static void createRegistries(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(new ResourceLocation("cb_microblock", "micro_material")).disableSaving().allowModification(), e -> {
            MICRO_MATERIALS = e;
        });
    }

    @Nullable
    public static MicroMaterial getMaterial(String name) {
        return MicroMaterialRegistry.getMaterial(new ResourceLocation(name));
    }

    @Nullable
    public static MicroMaterial getMaterial(ResourceLocation name) {
        return (MicroMaterial)MICRO_MATERIALS.getValue(name);
    }
}

