/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin;

import codechicken.asm.ASMHelper;
import codechicken.mixin.api.MixinBackend;
import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.api.MixinDebugger;
import codechicken.mixin.api.MixinLanguageSupport;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.FieldMixin;
import codechicken.mixin.util.MethodInfo;
import codechicken.mixin.util.MixinInfo;
import codechicken.mixin.util.ReflectionClassInfo;
import codechicken.mixin.util.SimpleServiceLoader;
import codechicken.mixin.util.Utils;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MixinCompilerImpl
implements MixinCompiler {
    public static final Level LOG_LEVEL = Level.valueOf((String)System.getProperty("codechicken.mixin.log_level", "DEBUG"));
    private static final Logger LOGGER = LoggerFactory.getLogger(MixinCompilerImpl.class);
    private final MixinBackend mixinBackend;
    private final MixinDebugger debugger;
    private final List<MixinLanguageSupport> languageSupportList;
    private final Map<String, MixinLanguageSupport> languageSupportMap;
    private final Map<String, byte[]> classBytesCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, ClassInfo> infoCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, MixinInfo> mixinMap = Collections.synchronizedMap(new HashMap());
    private final MixinClassLoader classLoader;

    public MixinCompilerImpl() {
        this(new MixinBackend.SimpleMixinBackend());
    }

    public MixinCompilerImpl(MixinBackend mixinBackend) {
        this(mixinBackend, new MixinDebugger.NullDebugger());
    }

    public MixinCompilerImpl(MixinBackend mixinBackend, MixinDebugger debugger) {
        this(mixinBackend, debugger, () -> new SimpleServiceLoader<MixinLanguageSupport>(MixinLanguageSupport.class).poll().getNewServices());
    }

    public MixinCompilerImpl(MixinBackend mixinBackend, MixinDebugger debugger, Supplier<Collection<Class<? extends MixinLanguageSupport>>> supportSupplier) {
        this.mixinBackend = mixinBackend;
        this.debugger = debugger;
        LOGGER.atLevel(LOG_LEVEL).log("Starting CodeChicken MixinCompiler.");
        LOGGER.atLevel(LOG_LEVEL).log("Loading MixinLanguageSupport services..");
        long start = System.nanoTime();
        ArrayList languageSupportInstances = FastStream.of((Iterable)supportSupplier.get()).map(x$0 -> new LanguageSupportInstance((Class<? extends MixinLanguageSupport>)x$0)).sorted(Comparator.comparingInt(e -> e.sortIndex)).toList();
        this.languageSupportList = FastStream.of((Iterable)languageSupportInstances).map(e -> e.instance).toList();
        HashMap<String, LanguageSupportInstance> languageSupportInstanceMap = new HashMap<String, LanguageSupportInstance>();
        for (LanguageSupportInstance instance : languageSupportInstances) {
            LanguageSupportInstance other = (LanguageSupportInstance)languageSupportInstanceMap.get(instance.name);
            if (other != null) {
                throw new RuntimeException(String.format("Duplicate MixinLanguageSupport. '%s' name conflicts with '%s'", instance, other));
            }
            languageSupportInstanceMap.put(instance.name, instance);
        }
        this.languageSupportMap = FastStream.of(languageSupportInstanceMap.entrySet()).toMap(Map.Entry::getKey, e -> ((LanguageSupportInstance)e.getValue()).instance);
        long end = System.nanoTime();
        LOGGER.atLevel(LOG_LEVEL).log("Loaded {} MixinLanguageSupport instances in {}.", (Object)this.languageSupportList.size(), (Object)Utils.timeString(start, end));
        this.classLoader = new MixinClassLoader(mixinBackend);
    }

    @Override
    public MixinBackend getMixinBackend() {
        return this.mixinBackend;
    }

    @Override
    @Nullable
    public <T extends MixinLanguageSupport> T getLanguageSupport(String name) {
        return (T)((MixinLanguageSupport)SneakyUtils.unsafeCast((Object)this.languageSupportMap.get(name)));
    }

    @Override
    @Nullable
    public ClassInfo getClassInfo(String name) {
        ClassInfo info = this.infoCache.get(name);
        if (info == null) {
            info = this.obtainInfo(name);
            this.infoCache.put(name, info);
        }
        return info;
    }

    @Override
    @Nullable
    public ClassInfo getClassInfo(ClassNode cNode) {
        ClassInfo info = this.infoCache.get(cNode.name);
        if (info == null) {
            info = this.obtainInfo(cNode);
            this.infoCache.put(cNode.name, info);
        }
        return info;
    }

    @Override
    public MixinInfo getMixinInfo(String name) {
        return this.mixinMap.get(name);
    }

    @Override
    public <T> Class<T> compileMixinClass(String name, String superClass, Set<String> traits) {
        ClassInfo baseInfo = this.getClassInfo(superClass);
        if (baseInfo == null) {
            throw new IllegalArgumentException("Provided super class does not exist.");
        }
        if (traits.isEmpty()) {
            try {
                return Class.forName(baseInfo.getName().replace('/', '.'), true, this.mixinBackend.getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Base class can't be loaded??", ex);
            }
        }
        long start = System.nanoTime();
        ArrayList baseTraits = FastStream.of(traits).map(this.mixinMap::get).toList();
        ArrayList mixinInfos = FastStream.of((Iterable)baseTraits).flatMap(MixinInfo::linearize).distinct().toList();
        ArrayList traitInfos = FastStream.of((Iterable)mixinInfos).map(MixinInfo::name).map(this::getClassInfo).toList();
        ClassNode cNode = new ClassNode();
        cNode.visit(52, 1, name, null, superClass, (String[])FastStream.of((Iterable)baseTraits).map(MixinInfo::name).toArray((Object[])new String[0]));
        MethodInfo cInit = (MethodInfo)FastStream.of(baseInfo.getMethods()).filter(e -> e.getName().equals("<init>")).first();
        MethodNode mInit = (MethodNode)cNode.visitMethod(1, "<init>", cInit.getDesc(), null, null);
        Utils.writeBridge((MethodVisitor)mInit, cInit.getDesc(), 183, superClass, "<init>", cInit.getDesc(), false);
        mInit.instructions.remove(mInit.instructions.getLast());
        ArrayList<Object> prevInfos = new ArrayList<Object>();
        for (Object t : mixinInfos) {
            int idx = 0;
            mInit.visitVarInsn(25, idx++);
            for (Type arg : Type.getArgumentTypes((String)cInit.getDesc())) {
                mInit.visitVarInsn(arg.getOpcode(21), idx);
                idx += arg.getSize();
            }
            mInit.visitMethodInsn(184, ((MixinInfo)t).name(), "$init$", Utils.staticDesc(((MixinInfo)t).name(), cInit.getDesc()), true);
            for (FieldMixin fieldMixin : ((MixinInfo)t).fields()) {
                FieldNode fv = (FieldNode)cNode.visitField(2, fieldMixin.getAccessName(((MixinInfo)t).name()), fieldMixin.desc(), null, null);
                Type fType = Type.getType((String)fv.desc);
                MethodVisitor mv = cNode.visitMethod(1, fv.name, "()" + fieldMixin.desc(), null, null);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, name, fv.name, fv.desc);
                mv.visitInsn(fType.getOpcode(172));
                mv.visitMaxs(-1, -1);
                mv = cNode.visitMethod(1, fv.name + "_$eq", "(" + fieldMixin.desc() + ")V", null, null);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(fType.getOpcode(21), 1);
                mv.visitFieldInsn(181, name, fv.name, fv.desc);
                mv.visitInsn(177);
                mv.visitMaxs(-1, -1);
            }
            for (String string : ((MixinInfo)t).supers()) {
                int nIdx = string.indexOf(40);
                String sName = string.substring(0, nIdx);
                String sDesc = string.substring(nIdx);
                MethodNode mv = (MethodNode)cNode.visitMethod(1, ((MixinInfo)t).name().replace("/", "$") + "$$super$" + sName, sDesc, null, null);
                MixinInfo prev = (MixinInfo)FastStream.of(prevInfos).reversed().filter(e -> ColUtils.anyMatch(e.methods(), m -> m.name.equals(sName) && m.desc.equals(sDesc))).firstOrDefault();
                if (prev != null) {
                    Utils.writeStaticBridge(mv, sName, prev);
                    continue;
                }
                MethodInfo mInfo = Objects.requireNonNull(baseInfo.findPublicImpl(sName, sDesc));
                Utils.writeBridge((MethodVisitor)mv, sDesc, 183, mInfo.getOwner().getName(), sName, sDesc, mInfo.getOwner().isInterface());
            }
            prevInfos.add(t);
        }
        mInit.visitInsn(177);
        HashSet<CallSite> methodSigs = new HashSet<CallSite>();
        for (MixinInfo t : Lists.reverse((List)mixinInfos)) {
            for (MethodNode m : t.methods()) {
                if (!methodSigs.add((CallSite)((Object)(m.name + m.desc)))) continue;
                MethodNode mv = (MethodNode)cNode.visitMethod(1, m.name, m.desc, null, m.exceptions.toArray(new String[0]));
                Utils.writeStaticBridge(mv, m.name, t);
            }
        }
        HashSet allParentInfos = FastStream.of((Object)baseInfo).concat((Iterable)traitInfos).flatMap(Utils::allParents).toSet();
        ArrayList allParentMethods = FastStream.of((Iterable)allParentInfos).flatMap(ClassInfo::getMethods).toList();
        for (String nameDesc : new HashSet(methodSigs)) {
            int nIdx = nameDesc.indexOf(40);
            String sName = nameDesc.substring(0, nIdx);
            String sDesc = nameDesc.substring(nIdx);
            String pDesc = sDesc.substring(0, sDesc.lastIndexOf(")") + 1);
            for (MethodInfo m : allParentMethods) {
                if (!m.getName().equals(sName) || !m.getDesc().startsWith(pDesc) || !methodSigs.add((CallSite)((Object)(m.getName() + m.getDesc())))) continue;
                MethodNode mv = (MethodNode)cNode.visitMethod(4161, m.getName(), m.getDesc(), null, m.getExceptions());
                Utils.writeBridge((MethodVisitor)mv, mv.desc, 182, cNode.name, sName, sDesc, (cNode.access & 0x200) != 0);
            }
        }
        byte[] byArray = ASMHelper.createBytes(cNode, 3);
        long end = System.nanoTime();
        LOGGER.atLevel(LOG_LEVEL).log("Generation of {} with [{}] took {}", new Object[]{superClass, String.join((CharSequence)", ", traits), Utils.timeString(start, end)});
        return this.defineClass(name, byArray);
    }

    @Override
    public <T> Class<T> defineClass(String name, byte[] bytes) {
        this.debugger.defineClass(name, bytes);
        return this.classLoader.defineClass(name, bytes);
    }

    @Override
    public <T> Class<T> getDefinedClass(String name) {
        return Objects.requireNonNull(this.classLoader.getDefinedClass(name), "Class was not defined by MixinCompiler. " + name);
    }

    @Override
    public MixinInfo registerTrait(ClassNode cNode) {
        MixinInfo info = this.mixinMap.get(cNode.name);
        if (info != null) {
            return info;
        }
        for (MixinLanguageSupport languageSupport : this.languageSupportList) {
            info = languageSupport.buildMixinTrait(cNode);
            if (info == null) continue;
            if (!cNode.name.equals(info.name())) {
                throw new IllegalStateException("Traits must have the same name as their ClassNode. Got: " + info.name() + ", Expected: " + cNode.name);
            }
            this.mixinMap.put(info.name(), info);
            return info;
        }
        throw new IllegalStateException("No MixinLanguageSupport wished to handle class '" + cNode.name + "'");
    }

    private ClassInfo obtainInfo(ClassNode cNode) {
        for (MixinLanguageSupport languageSupport : this.languageSupportList) {
            ClassInfo info = languageSupport.obtainInfo(cNode);
            if (info == null) continue;
            return info;
        }
        throw new IllegalStateException("Java plugin did not create ClassInfo for existing node: " + cNode.name);
    }

    @Nullable
    private ClassInfo obtainInfo(String cName) {
        ClassNode cNode = this.getClassNode(cName);
        if (cNode != null) {
            return this.obtainInfo(cNode);
        }
        try {
            return new ReflectionClassInfo(this, Class.forName(cName.replace('/', '.'), true, this.mixinBackend.getContextClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public ClassNode getClassNode(String name) {
        if (name.equals("java/lang/Object")) {
            return null;
        }
        byte[] bytes = this.classBytesCache.computeIfAbsent(name, this.mixinBackend::getBytes);
        if (bytes == null) {
            return null;
        }
        return ASMHelper.createClassNode(bytes, 8);
    }

    private class LanguageSupportInstance {
        private final Class<? extends MixinLanguageSupport> clazz;
        private final MixinLanguageSupport instance;
        private final String name;
        private final int sortIndex;

        public LanguageSupportInstance(Class<? extends MixinLanguageSupport> clazz) {
            Object[] args;
            this.clazz = clazz;
            MixinLanguageSupport.LanguageName lName = clazz.getAnnotation(MixinLanguageSupport.LanguageName.class);
            MixinLanguageSupport.SortingIndex sIndex = clazz.getAnnotation(MixinLanguageSupport.SortingIndex.class);
            if (lName == null) {
                throw new RuntimeException("MixinLanguageSupport '" + clazz.getName() + "' is not annotated with MixinLanguageSupport.LanguageName!");
            }
            this.name = lName.value();
            this.sortIndex = sIndex != null ? sIndex.value() : 1000;
            LOGGER.atLevel(LOG_LEVEL).log("Loading MixinLanguageSupport '{}', Name: '{}', Sorting Index: '{}'", new Object[]{clazz.getName(), this.name, this.sortIndex});
            Constructor<? extends MixinLanguageSupport> ctor = Utils.findConstructor(clazz, MixinCompiler.class);
            if (ctor != null) {
                args = new Object[]{MixinCompilerImpl.this};
            } else {
                ctor = Utils.findConstructor(clazz, new Class[0]);
                args = new Object[]{};
            }
            if (ctor == null) {
                throw new RuntimeException("Expected MixinLanguageSupport to have either no-args ctor or take a MixinCompiler instance.");
            }
            this.instance = Utils.newInstance(ctor, args);
        }

        public String toString() {
            return new StringJoiner(", ", LanguageSupportInstance.class.getSimpleName() + "[", "]").add("class=" + this.clazz.getName()).add("name='" + this.name + "'").add("sortIndex=" + this.sortIndex).toString();
        }
    }

    private static class MixinClassLoader
    extends ClassLoader {
        public MixinClassLoader(MixinBackend mixinBackend) {
            super(mixinBackend.getContextClassLoader());
        }

        public Class<?> defineClass(String cName, byte[] bytes) {
            return this.defineClass(cName.replace('/', '.'), bytes, 0, bytes.length);
        }

        public Class<?> getDefinedClass(String cName) {
            return this.findLoadedClass(cName.replace('/', '.'));
        }
    }
}

