/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.util.MethodInfo;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public abstract class ClassInfo {
    protected MixinCompiler mixinCompiler;

    protected ClassInfo(MixinCompiler mixinCompiler) {
        this.mixinCompiler = mixinCompiler;
    }

    public abstract String getName();

    public abstract boolean isInterface();

    @Nullable
    public abstract ClassInfo getSuperClass();

    public abstract Iterable<ClassInfo> getInterfaces();

    public abstract Iterable<MethodInfo> getMethods();

    public FastStream<MethodInfo> getParentMethods() {
        return FastStream.ofNullable((Object)this.getSuperClass()).concat(this.getInterfaces()).flatMap(ClassInfo::getAllMethods);
    }

    public FastStream<MethodInfo> getAllMethods() {
        return FastStream.concat((Iterable[])new Iterable[]{this.getMethods(), this.getParentMethods()});
    }

    @Nullable
    public MethodInfo findPublicImpl(String name, String desc) {
        return (MethodInfo)this.getAllMethods().filter(m -> m.getName().equals(name)).filter(m -> m.getDesc().equals(desc)).filter(m -> !m.isAbstract() && !m.isPrivate()).firstOrDefault();
    }

    @Nullable
    public MethodInfo findPublicParentImpl(String name, String desc) {
        return (MethodInfo)this.getParentMethods().filter(m -> m.getName().equals(name)).filter(m -> m.getDesc().equals(desc)).filter(m -> !m.isAbstract() && !m.isPrivate()).firstOrDefault();
    }

    @Nullable
    public ClassInfo concreteParent() {
        return this.getSuperClass();
    }

    public boolean inheritsFrom(String parentName) {
        return FastStream.ofNullable((Object)this.concreteParent()).concat(this.getInterfaces()).anyMatch(e -> e.getName().equals(parentName) || e.inheritsFrom(parentName));
    }

    public String getModuleName() {
        return this.getName();
    }
}

