/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.asm.ASMHelper;
import codechicken.asm.ClassHierarchyManager;
import codechicken.asm.InsnComparator;
import codechicken.asm.InsnListSection;
import codechicken.asm.StackAnalyser;
import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.util.FieldMixin;
import codechicken.mixin.util.MethodInfo;
import codechicken.mixin.util.MixinInfo;
import codechicken.mixin.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class JavaTraitGenerator {
    protected final MixinCompiler mixinCompiler;
    protected final ClassNode cNode;
    protected final ClassNode sNode;
    protected final ClassNode tNode;
    protected List<FieldNode> staticFields;
    protected List<FieldNode> instanceFields;
    protected List<FieldMixin> traitFields;
    protected List<MethodNode> traitMethods = new ArrayList<MethodNode>();
    protected Set<String> supers = new LinkedHashSet<String>();
    protected MixinInfo mixinInfo;
    protected Map<String, String> fieldNameLookup;
    protected Map<String, MethodNode> methodSigLookup;

    public JavaTraitGenerator(MixinCompiler mixinCompiler, ClassNode cNode) {
        this.mixinCompiler = mixinCompiler;
        this.cNode = cNode;
        this.tNode = new ClassNode();
        this.sNode = new ClassNode();
        this.checkNode();
        this.staticFields = FastStream.of((Iterable)cNode.fields).filter(e -> (e.access & 8) != 0).toList();
        this.instanceFields = FastStream.of((Iterable)cNode.fields).filter(e -> (e.access & 8) == 0).toList();
        this.traitFields = FastStream.of(this.instanceFields).map(f -> new FieldMixin(f.name, f.desc, f.access)).toList();
        this.fieldNameLookup = FastStream.of(this.traitFields).toMap(FieldMixin::name, e -> e.getAccessName(cNode.name));
        this.methodSigLookup = FastStream.of((Iterable)cNode.methods).toMap(e -> e.name + e.desc, Function.identity());
        this.mixinInfo = this.operate();
    }

    protected void checkNode() {
        this.preCheckNode();
        if ((this.cNode.access & 0x200) != 0) {
            throw new IllegalArgumentException("Cannot register java interface '" + this.cNode.name + "' as a mixin trait.");
        }
        if (!this.cNode.innerClasses.isEmpty() && !ColUtils.anyMatch((Iterable)this.cNode.innerClasses, innerNode -> innerNode.outerName != null && !this.cNode.name.equals(innerNode.outerName) && !innerNode.name.startsWith(this.cNode.name))) {
            throw new IllegalArgumentException("Found illegal inner class for '" + this.cNode.name + "', use scala.");
        }
        ArrayList invalidFields = FastStream.of((Iterable)this.cNode.fields).filter(e -> (e.access & 2) == 0).toList();
        if (!invalidFields.isEmpty()) {
            String fields = "[" + FastStream.of((Iterable)invalidFields).map(e -> e.name).join(", ") + "]";
            throw new IllegalArgumentException("Illegal fields " + fields + " found in " + this.cNode.name + ". These fields must be private.");
        }
        if ((this.cNode.access & 0x400) != 0) {
            throw new IllegalArgumentException("Cannot register abstract class " + this.cNode.name + " as a java mixin trait. Use scala");
        }
    }

    protected MixinInfo operate() {
        this.beforeTransform();
        this.sNode.visit(52, 1, this.cNode.name + "$", null, "java/lang/Object", new String[0]);
        this.sNode.sourceFile = this.cNode.sourceFile;
        this.tNode.visit(52, 1537, this.cNode.name, null, "java/lang/Object", this.cNode.interfaces.toArray(new String[0]));
        this.tNode.sourceFile = this.cNode.sourceFile;
        this.staticFields.forEach(f -> this.sNode.visitField(8, f.name, f.desc, f.signature, f.value));
        this.traitFields.forEach(f -> {
            this.tNode.visitMethod(1025, this.fieldNameLookup.get(f.name()), "()" + f.desc(), null, null);
            this.tNode.visitMethod(1025, this.fieldNameLookup.get(f.name()) + "_$eq", "(" + f.desc() + ")V", null, null);
        });
        this.cNode.methods.forEach(this::convertMethod);
        return new MixinInfo(this.tNode.name, this.cNode.superName, Collections.emptyList(), this.traitFields, this.traitMethods, List.copyOf(this.supers));
    }

    protected void preCheckNode() {
    }

    protected void beforeTransform() {
    }

    @Nullable
    public ClassNode getStaticNode() {
        if (this.sNode.methods.isEmpty() && this.sNode.fields.isEmpty()) {
            return null;
        }
        return this.sNode;
    }

    public ClassNode getTraitNode() {
        return this.tNode;
    }

    public MixinInfo getMixinInfo() {
        return this.mixinInfo;
    }

    private void staticTransform(MethodNode mNode, MethodNode base) {
        AbstractInsnNode insn;
        StackAnalyser stack = new StackAnalyser(Type.getObjectType((String)this.cNode.name), base);
        InsnList insnList = mNode.instructions;
        InsnPointer pointer = new InsnPointer(insnList);
        while ((insn = pointer.get()) != null) {
            if (insn instanceof FieldInsnNode) {
                FieldInsnNode fInsn = (FieldInsnNode)insn;
                if (fInsn.owner.equals(this.cNode.name)) {
                    if (insn.getOpcode() == 180) {
                        pointer.replace((AbstractInsnNode)new MethodInsnNode(185, this.cNode.name, this.fieldNameLookup.get(fInsn.name), "()" + fInsn.desc, true));
                    } else if (insn.getOpcode() == 181) {
                        pointer.replace((AbstractInsnNode)new MethodInsnNode(185, this.cNode.name, this.fieldNameLookup.get(fInsn.name) + "_$eq", "(" + fInsn.desc + ")V", true));
                    } else if (insn.getOpcode() == 178 || insn.getOpcode() == 179) {
                        fInsn.owner = fInsn.owner + "$";
                    }
                }
            } else if (insn instanceof MethodInsnNode) {
                mInsn = (MethodInsnNode)insn;
                if (mInsn.getOpcode() == 183) {
                    MethodInfo sMethod = this.getSuper(mInsn, stack);
                    if (sMethod != null) {
                        String bridgeName = this.cNode.name.replace("/", "$") + "$$super$" + mInsn.name;
                        if (this.supers.add(mInsn.name + mInsn.desc)) {
                            this.tNode.visitMethod(1025, bridgeName, mInsn.desc, null, null);
                        }
                        pointer.replace((AbstractInsnNode)new MethodInsnNode(185, this.cNode.name, bridgeName, mInsn.desc, true));
                    } else {
                        MethodNode target = this.methodSigLookup.get(mInsn.name + mInsn.desc);
                        if (target != null && (target.access & 2) != 0) {
                            pointer.replace((AbstractInsnNode)new MethodInsnNode(184, mInsn.owner, mInsn.name, Utils.staticDesc(mInsn.owner, mInsn.desc), true));
                        }
                    }
                } else if (mInsn.getOpcode() == 182) {
                    if (mInsn.owner.equals(this.cNode.name)) {
                        MethodNode target = this.methodSigLookup.get(mInsn.name + mInsn.desc);
                        if (target != null) {
                            if ((target.access & 2) != 0) {
                                pointer.replace((AbstractInsnNode)new MethodInsnNode(184, mInsn.owner, mInsn.name, Utils.staticDesc(mInsn.owner, mInsn.desc), true));
                            } else {
                                pointer.replace((AbstractInsnNode)new MethodInsnNode(185, mInsn.owner, mInsn.name, mInsn.desc, true));
                            }
                        } else {
                            Type mType = Type.getMethodType((String)mInsn.desc);
                            StackAnalyser.StackEntry instanceEntry = stack.peek(StackAnalyser.width(mType.getArgumentTypes()));
                            insnList.insert(instanceEntry.insn, (AbstractInsnNode)new TypeInsnNode(192, this.cNode.superName));
                            mInsn.owner = this.cNode.superName;
                        }
                    }
                    List<StackAnalyser.StackEntry> entries = JavaTraitGenerator.peekArgs(stack, mInsn.desc);
                    Type[] argumentTypes = Type.getMethodType((String)mInsn.desc).getArgumentTypes();
                    for (int i = 0; i < argumentTypes.length; ++i) {
                        Type arg = argumentTypes[i];
                        StackAnalyser.StackEntry entry = entries.get(i);
                        if (arg.getInternalName().equals("java/lang/Object") || !ClassHierarchyManager.classExtends(this.cNode.superName.replace("/", "."), arg.getInternalName().replace("/", "."))) continue;
                        insnList.insert(entry.insn, (AbstractInsnNode)new TypeInsnNode(192, this.cNode.superName));
                    }
                } else if (mInsn.getOpcode() == 184 && mInsn.owner.equals(this.cNode.name) && this.methodSigLookup.get(mInsn.name + mInsn.desc) != null) {
                    mInsn.owner = mInsn.owner + "$";
                }
            } else if (insn instanceof InvokeDynamicInsnNode) {
                mInsn = (InvokeDynamicInsnNode)insn;
                Object[] bsmArgs = mInsn.bsmArgs;
                for (int i = 0; i < bsmArgs.length; ++i) {
                    Handle handle;
                    Object bsmArg = bsmArgs[i];
                    if (!(bsmArg instanceof Handle) || !(handle = (Handle)bsmArg).getOwner().equals(this.cNode.name) || handle.getTag() != 6) continue;
                    bsmArgs[i] = new Handle(handle.getTag(), handle.getOwner() + "$", handle.getName(), handle.getDesc(), handle.isInterface());
                }
            }
            stack.visitInsn(pointer.get());
            pointer.advance();
        }
    }

    private void convertMethod(MethodNode mNode) {
        MethodNode mv;
        int access;
        if (mNode.name.equals("<init>")) {
            MethodNode mv2 = this.staticClone(mNode, "$init$", 1);
            InsnListSection insns = new InsnListSection();
            int idx = 0;
            insns.add((AbstractInsnNode)new VarInsnNode(25, idx++));
            for (Type arg : Type.getArgumentTypes((String)mNode.desc)) {
                insns.add((AbstractInsnNode)new VarInsnNode(arg.getOpcode(21), idx));
                idx += arg.getSize();
            }
            insns.add((AbstractInsnNode)new MethodInsnNode(183, this.cNode.superName, "<init>", mNode.desc, false));
            InsnListSection mInsns = new InsnListSection(mv2.instructions);
            InsnListSection found = InsnComparator.matches(mInsns, insns, Collections.emptySet());
            if (found == null) {
                throw new IllegalArgumentException("Invalid constructor insn sequence " + this.cNode.name + "\n" + mInsns);
            }
            found.trim(Collections.emptySet()).remove();
            this.staticTransform(mv2, mNode);
            return;
        }
        if ((mNode.access & 8) != 0) {
            int mask = 6;
            int access2 = mNode.access & ~mask | 1;
            MethodNode mv3 = (MethodNode)this.sNode.visitMethod(access2, mNode.name, mNode.desc, null, null);
            ASMHelper.copy(mNode, mv3);
            this.staticTransform(mv3, mNode);
            return;
        }
        boolean isPrivate = (mNode.access & 2) != 0;
        int n = access = !isPrivate ? 1 : 2;
        if (!isPrivate) {
            mv = this.tNode.visitMethod(1025, mNode.name, mNode.desc, null, mNode.exceptions.toArray(new String[0]));
            this.traitMethods.add(mv);
        }
        mv = this.staticClone(mNode, (String)(!isPrivate ? mNode.name + "$" : mNode.name), access);
        this.staticTransform(mv, mNode);
    }

    @Nullable
    private MethodInfo getSuper(MethodInsnNode mInsn, StackAnalyser stack) {
        if (mInsn.owner.equals(stack.owner.getInternalName())) {
            return null;
        }
        String methodName = stack.mNode.name.replaceAll(".+\\Q$$super$\\E", "");
        if (!mInsn.name.equals(methodName)) {
            return null;
        }
        StackAnalyser.StackEntry entry = stack.peek(Type.getType((String)mInsn.desc).getArgumentTypes().length);
        if (!(entry instanceof StackAnalyser.Load)) {
            return null;
        }
        StackAnalyser.Load load = (StackAnalyser.Load)entry;
        if (!(load.e instanceof StackAnalyser.This)) {
            return null;
        }
        return Objects.requireNonNull(this.mixinCompiler.getClassInfo(stack.owner.getInternalName()), "Failed to load class: " + stack.owner.getInternalName()).findPublicParentImpl(methodName, mInsn.desc);
    }

    private MethodNode staticClone(MethodNode mNode, String name, int access) {
        ClassNode target = mNode.name.equals("<clinit>") ? this.sNode : this.tNode;
        String desc = (mNode.access & 8) == 0 ? Utils.staticDesc(this.cNode.name, mNode.desc) : mNode.desc;
        MethodNode mv = (MethodNode)target.visitMethod(access | 8, name, desc, null, mNode.exceptions.toArray(new String[0]));
        ASMHelper.copy(mNode, mv);
        return mv;
    }

    private static List<StackAnalyser.StackEntry> peekArgs(StackAnalyser analyser, String desc) {
        int len = Type.getArgumentTypes((String)desc).length;
        StackAnalyser.StackEntry[] args = new StackAnalyser.StackEntry[len];
        for (int i = 0; i < len; ++i) {
            args[len - i - 1] = analyser.peek(i);
        }
        return Arrays.asList(args);
    }

    public static class InsnPointer {
        public final InsnList insnList;
        @Nullable
        public AbstractInsnNode pointer;

        public InsnPointer(InsnList insnList) {
            this.insnList = insnList;
            this.pointer = insnList.getFirst();
        }

        private void replace(AbstractInsnNode newInsn) {
            this.insnList.insert(this.pointer, newInsn);
            this.insnList.remove(this.pointer);
            this.pointer = newInsn;
        }

        @Nullable
        public AbstractInsnNode get() {
            return this.pointer;
        }

        public AbstractInsnNode advance() {
            assert (this.pointer != null);
            this.pointer = this.pointer.getNext();
            return this.pointer;
        }
    }
}

