/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.MethodInfo;
import codechicken.mixin.util.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import net.covers1624.quack.collection.FastStream;
import org.objectweb.asm.Type;

public class ReflectionClassInfo
extends ClassInfo {
    private final Class<?> clazz;
    private final String name;
    private final List<ClassInfo> interfaces;
    private final List<MethodInfo> methods;

    public ReflectionClassInfo(MixinCompiler mixinCompiler, Class<?> clazz) {
        super(mixinCompiler);
        this.clazz = clazz;
        this.name = Utils.asmName(clazz.getName());
        this.interfaces = FastStream.of((Object[])clazz.getInterfaces()).map(mixinCompiler::getClassInfo).toList();
        this.methods = FastStream.of((Object[])clazz.getMethods()).map(x$0 -> new ReflectionMethodInfo((Method)x$0)).toList(FastStream.infer());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public ClassInfo getSuperClass() {
        return this.mixinCompiler.getClassInfo(this.clazz.getSuperclass());
    }

    @Override
    public Iterable<ClassInfo> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public Iterable<MethodInfo> getMethods() {
        return this.methods;
    }

    public class ReflectionMethodInfo
    implements MethodInfo {
        private final String name;
        private final String desc;
        private final String[] exceptions;
        private final boolean isPrivate;
        private final boolean isAbstract;

        private ReflectionMethodInfo(Method method) {
            this.name = method.getName();
            this.desc = Type.getType((Method)method).getDescriptor();
            this.exceptions = (String[])FastStream.of((Object[])method.getExceptionTypes()).map(Class::getName).map(Utils::asmName).toArray((Object[])new String[0]);
            this.isPrivate = Modifier.isPrivate(method.getModifiers());
            this.isAbstract = Modifier.isAbstract(method.getModifiers());
        }

        @Override
        public ClassInfo getOwner() {
            return ReflectionClassInfo.this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDesc() {
            return this.desc;
        }

        @Override
        public String[] getExceptions() {
            return this.exceptions;
        }

        @Override
        public boolean isPrivate() {
            return this.isPrivate;
        }

        @Override
        public boolean isAbstract() {
            return this.isAbstract;
        }
    }
}

