/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.mixin.aquiferfix;

import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.worldgen.context.AquiferContext;
import com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion.LiquidRegions;
import com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion.LiquidRegionsController;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Aquifer.NoiseBasedAquifer.class})
public class AquiferMixin {
    @Unique
    private static int logCounter = 0;
    @Unique
    private static final int MAX_LOG_COUNTER = 20;
    @Unique
    private static boolean PRINTED_FINAL_ERROR = false;

    @Inject(method={"computeSubstance"}, at={@At(value="RETURN")}, cancellable=true)
    private void bettercaves$fixAquiferLiquids(DensityFunction.FunctionContext context, double d, CallbackInfoReturnable<BlockState> cir) {
        if (logCounter > 20) {
            if (!PRINTED_FINAL_ERROR) {
                BetterCavesCommon.LOGGER.error("Failed to fetch the AquiferContext. Liquid Regions for YUNG's Better Caves may not generate properly.");
                BetterCavesCommon.LOGGER.error("This is a mod compatibility issue. Please report it to the Better Caves GitHub issue tracker!");
                PRINTED_FINAL_ERROR = true;
            }
            return;
        }
        AquiferContext aquiferContext = AquiferContext.peek();
        if (aquiferContext == null) {
            if (logCounter < 20) {
                BetterCavesCommon.LOGGER.warn("AquiferContext is null in AquiferMixin, this should not happen!");
            }
            ++logCounter;
            return;
        }
        ServerLevel serverLevel = aquiferContext.getServerLevel();
        if (!LiquidRegionsController.getInstance().hasSettingsForLevel(serverLevel)) {
            return;
        }
        BlockState blockState = (BlockState)cir.getReturnValue();
        if (blockState == null) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos(context.m_207115_(), context.m_207114_(), context.m_207113_()));
        LiquidRegions liquidRegions = LiquidRegionsController.getInstance().getLiquidRegionsForServerLevel(serverLevel);
        LiquidRegions.CacheData cacheData = liquidRegions.getOrCreateLiquidBlocksForChunk(chunkPos);
        if (cacheData == null) {
            BetterCavesCommon.LOGGER.warn("No LiquidRegions data found for chunk {} in AquiferMixin, this should not happen!", (Object)chunkPos);
            return;
        }
        if (context.m_207114_() > cacheData.liquidAltitude()) {
            return;
        }
        int localX = context.m_207115_() & 0xF;
        int localZ = context.m_207113_() & 0xF;
        BlockState liquidBlock = cacheData.liquidBlocks()[localX][localZ];
        if (liquidBlock == null || !blockState.m_60713_(liquidBlock.m_60734_())) {
            cir.setReturnValue((Object)liquidBlock);
        }
    }
}

