/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.layer;

import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.AbstractCarver;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CarverNoiseRange;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CaveCarver;
import com.yungnickyoung.minecraft.yungsapi.math.ColPos;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;

public class CaveLayer {
    private final FastNoise caveRegionSampler;
    private final List<CarverNoiseRange> noiseRanges = new ArrayList<CarverNoiseRange>();
    private final BetterCavesWorldCarverConfig config;
    private final boolean isDebugViewEnabled;
    private final boolean isOverrideSurfaceDetectionEnabled;

    public CaveLayer(ServerLevel serverLevel, BetterCavesWorldCarverConfig config, BetterCavesWorldCarverConfig.CaveLayerSettings layerSettings) {
        this.config = config;
        this.isDebugViewEnabled = config.debugSettings.enabled();
        this.isOverrideSurfaceDetectionEnabled = config.misc.overrideSurfaceDetection();
        double caveRegionSize = layerSettings.caveRegionSizeFrequency();
        this.caveRegionSampler = new FastNoise();
        this.caveRegionSampler.SetSeed((int)serverLevel.m_7328_() + 222);
        this.caveRegionSampler.SetFrequency((float)caveRegionSize);
        this.caveRegionSampler.SetNoiseType(FastNoise.NoiseType.Cellular);
        this.caveRegionSampler.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Natural);
        List<AbstractCarver> carvers = CaveCarver.createCarversFromConfig(serverLevel, config, layerSettings);
        carvers.removeIf(carver -> carver.getSpawnWeight() == 0);
        float maxPossibleNoiseThreshold = (float)(layerSettings.caveSpawnChance() * 0.01 * 2.0 - 1.0);
        int totalSpawnWeight = carvers.stream().map(AbstractCarver::getSpawnWeight).reduce(0, Integer::sum);
        float totalRangeLength = maxPossibleNoiseThreshold - -1.0f;
        float currNoise = -1.0f;
        BetterCavesCommon.LOGGER.debug("CAVE INFORMATION");
        BetterCavesCommon.LOGGER.debug("--> MAX POSSIBLE THRESHOLD: {}", (Object)Float.valueOf(maxPossibleNoiseThreshold));
        BetterCavesCommon.LOGGER.debug("--> TOTAL SPAWN WEIGHT: {}", (Object)totalSpawnWeight);
        BetterCavesCommon.LOGGER.debug("--> TOTAL RANGE LENGTH: {}", (Object)Float.valueOf(totalRangeLength));
        for (AbstractCarver carver2 : carvers) {
            BetterCavesCommon.LOGGER.debug("--> CARVER");
            float noiseRangeLength = (float)carver2.getSpawnWeight() / (float)totalSpawnWeight * totalRangeLength;
            float rangeTop = currNoise + noiseRangeLength;
            CarverNoiseRange range = new CarverNoiseRange(currNoise, rangeTop, carver2);
            currNoise = rangeTop;
            this.noiseRanges.add(range);
            BetterCavesCommon.LOGGER.debug("    --> RANGE FOUND: {}", (Object)range);
        }
    }

    public void carveChunk(ChunkAccess chunkAccess, int[][] surfaceAltitudes, BlockState[][] liquidBlocks, Function<BlockPos, Holder<Biome>> biomeProvider, CarvingMask carvingMask, Aquifer aquifer) {
        if (this.noiseRanges.isEmpty()) {
            return;
        }
        for (int subX = 0; subX < 4; ++subX) {
            for (int subZ = 0; subZ < 4; ++subZ) {
                int localSubStartX = subX * 4;
                int localSubStartZ = subZ * 4;
                int localSubEndX = localSubStartX + 4 - 1;
                int localSubEndZ = localSubStartZ + 4 - 1;
                BlockPos startPos = new BlockPos(chunkAccess.m_7697_().f_45578_ * 16 + localSubStartX, 1, chunkAccess.m_7697_().f_45579_ * 16 + localSubStartZ);
                BlockPos endPos = new BlockPos(chunkAccess.m_7697_().f_45578_ * 16 + localSubEndX, 1, chunkAccess.m_7697_().f_45579_ * 16 + localSubEndZ);
                int maxHeight = Integer.MIN_VALUE;
                if (!this.isOverrideSurfaceDetectionEnabled) {
                    for (int x = localSubStartX; x < localSubEndX; ++x) {
                        for (int z = localSubStartZ; z < localSubEndZ; ++z) {
                            maxHeight = Math.max(maxHeight, surfaceAltitudes[x][z]);
                        }
                    }
                    for (CarverNoiseRange range : this.noiseRanges) {
                        maxHeight = Math.max(maxHeight, range.getCarver().getTopY());
                    }
                } else {
                    for (CarverNoiseRange range : this.noiseRanges) {
                        maxHeight = Math.max(maxHeight, range.getCarver().getTopY());
                    }
                }
                if (this.isDebugViewEnabled) {
                    maxHeight = this.config.debugSettings.topY();
                }
                HashMap<CarverNoiseRange, double[][][][]> noiseCubes = new HashMap<CarverNoiseRange, double[][][][]>();
                for (CarverNoiseRange range : this.noiseRanges) {
                    double[][][][] noiseCube = range.getCarver().getNoiseGen().interpolateNoiseCube(startPos, endPos, range.getCarver().getBottomY(), maxHeight);
                    noiseCubes.put(range, noiseCube);
                }
                for (int offsetX = 0; offsetX < 4; ++offsetX) {
                    block8: for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                        int localX = localSubStartX + offsetX;
                        int localZ = localSubStartZ + offsetZ;
                        ColPos colPos = new ColPos(chunkAccess.m_7697_().f_45578_ * 16 + localX, chunkAccess.m_7697_().f_45579_ * 16 + localZ);
                        int surfaceAltitude = surfaceAltitudes[localX][localZ];
                        BlockState liquidBlock = liquidBlocks[localX][localZ];
                        float caveRegionNoise = this.caveRegionSampler.GetNoise((float)colPos.getX(), (float)colPos.getZ());
                        for (CarverNoiseRange range : this.noiseRanges) {
                            int topY;
                            if (!range.contains(caveRegionNoise)) continue;
                            int n = topY = this.isOverrideSurfaceDetectionEnabled ? range.getCarver().getTopY() : Math.min(surfaceAltitude, range.getCarver().getTopY());
                            if (this.isDebugViewEnabled) {
                                topY = 128;
                            }
                            double[][] noiseColumn = ((double[][][][])noiseCubes.get(range))[offsetX][offsetZ];
                            ((CaveCarver)range.getCarver()).carveColumn(this.config, chunkAccess, colPos, topY, noiseColumn, liquidBlock, carvingMask, aquifer);
                            continue block8;
                        }
                    }
                }
            }
        }
    }
}

