/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.cannon_mount;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;

public abstract class CannonMountInterfaceBlockEntity
extends KineticBlockEntity {
    protected final CannonMountBlockEntity parent;
    private double sequencedAngleLimit;

    public CannonMountInterfaceBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state, CannonMountBlockEntity parent) {
        super(typeIn, pos, state);
        this.parent = parent;
        this.setLazyTickRate(3);
        this.sequencedAngleLimit = -1.0;
    }

    public float calculateStressApplied() {
        return this.parent.calculateCannonStressApplied();
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.sequencedAngleLimit = -1.0;
        if (this.sequenceContext != null && this.sequenceContext.instruction() == SequencerInstructions.TURN_ANGLE) {
            this.sequencedAngleLimit = this.sequenceContext.getEffectiveValue((double)this.getTheoreticalSpeed()) * 0.125;
        }
    }

    public void tryUpdateSpeed() {
        if (this.preventSpeedUpdate > 0) {
            return;
        }
        this.warnOfMovement();
        this.clearKineticInformation();
        this.updateSpeed = true;
    }

    public double getSequencedAngleLimit() {
        return this.sequencedAngleLimit;
    }

    public void setSequencedAngleLimit(double value) {
        this.sequencedAngleLimit = value;
    }

    public void sendData() {
        this.parent.sendData();
    }

    public void m_6596_() {
        this.parent.m_6596_();
    }

    public static class YawInterface
    extends CannonMountInterfaceBlockEntity {
        public YawInterface(BlockEntityType<?> typeIn, BlockPos pos, BlockState state, CannonMountBlockEntity parent) {
            super(typeIn, pos, state, parent);
        }

        public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
            Direction vertical = (Direction)state.m_61143_((Property)BlockStateProperties.f_155997_);
            return List.of(this.f_58858_.m_121945_(vertical));
        }
    }

    public static class PitchInterface
    extends CannonMountInterfaceBlockEntity {
        public PitchInterface(BlockEntityType<?> typeIn, BlockPos pos, BlockState state, CannonMountBlockEntity parent) {
            super(typeIn, pos, state, parent);
        }

        public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
            Direction.Axis axis = block.getRotationAxis(state);
            BlockPos pos1 = BlockPos.f_121853_.m_121945_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
            return List.of(this.f_58858_.m_121955_((Vec3i)pos1), this.f_58858_.m_121996_((Vec3i)pos1));
        }
    }
}

