/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeSerializer;
import rbasamoyai.createbigcannons.crafting.BlockRecipeType;
import rbasamoyai.createbigcannons.crafting.casting.AbstractCannonCastBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class CannonCastingRecipe
implements BlockRecipe {
    private final CannonCastShape requiredShape;
    private final FluidIngredient ingredient;
    private final Block result;
    private final ResourceLocation id;

    public CannonCastingRecipe(CannonCastShape requiredShape, FluidIngredient ingredient, Block result, ResourceLocation id) {
        this.requiredShape = requiredShape;
        this.ingredient = ingredient;
        this.result = result;
        this.id = id;
    }

    public CannonCastShape shape() {
        return this.requiredShape;
    }

    public FluidIngredient ingredient() {
        return this.ingredient;
    }

    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public boolean matches(Level level, BlockPos pos) {
        AbstractCannonCastBlockEntity cast;
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof AbstractCannonCastBlockEntity && (cast = (AbstractCannonCastBlockEntity)blockEntity).matchesRecipe(this);
    }

    @Override
    public void assembleInWorld(Level level, BlockPos pos) {
        AbstractCannonCastBlockEntity cast;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof AbstractCannonCastBlockEntity) || !(cast = (AbstractCannonCastBlockEntity)blockEntity).canRenderCastModel()) {
            return;
        }
        cast.m_7651_();
        BlockState state = this.result.m_49966_();
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN);
        }
        state = this.requiredShape.applyTo(state);
        level.m_7731_(pos, state, 11);
    }

    @Override
    public Block getResultBlock() {
        return this.result;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public BlockRecipeSerializer<?> getSerializer() {
        return BlockRecipeSerializer.CANNON_CASTING;
    }

    @Override
    public BlockRecipeType<?> getType() {
        return BlockRecipeType.CANNON_CASTING;
    }

    public static class Serializer
    implements BlockRecipeSerializer<CannonCastingRecipe> {
        @Override
        public CannonCastingRecipe fromJson(ResourceLocation id, JsonObject obj) {
            CannonCastShape shape = (CannonCastShape)CBCRegistries.cannonCastShapes().m_7745_(CBCUtils.location(obj.get("cast_shape").getAsString()));
            FluidIngredient ingredient = FluidIngredient.deserialize((JsonElement)obj.get("fluid"));
            Block result = CBCRegistryUtils.getBlock(CBCUtils.location(obj.get("result").getAsString()));
            return new CannonCastingRecipe(shape, ingredient, result, id);
        }

        @Override
        public CannonCastingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            CannonCastShape shape = (CannonCastShape)CBCRegistries.cannonCastShapes().m_7942_(buf.m_130242_());
            Block result = CBCRegistryUtils.getBlock(buf.m_130242_());
            FluidIngredient ingredient = FluidIngredient.read((FriendlyByteBuf)buf);
            return new CannonCastingRecipe(shape, ingredient, result, id);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, CannonCastingRecipe recipe) {
            buf.m_130130_(CBCRegistries.cannonCastShapes().m_7447_((Object)recipe.shape())).m_130130_(CBCRegistryUtils.getBlockNumericId(recipe.getResultBlock()));
            recipe.ingredient().write(buf);
        }
    }
}

