/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.explosions;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function7;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleData;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class AbstractBlastWaveEffectParticleData<DATA extends AbstractBlastWaveEffectParticleData<DATA>>
implements ParticleOptions,
ICustomParticleData<DATA> {
    private final double blastRadius;
    private final Holder<SoundEvent> soundEvent;
    private final SoundSource soundSource;
    private final float volume;
    private final float pitch;
    private final float airAbsorption;
    private final float power;

    protected static <DATA extends AbstractBlastWaveEffectParticleData<DATA>> ParticleOptions.Deserializer<DATA> createDeserializer(final Constructor<DATA> cons) {
        return new ParticleOptions.Deserializer<DATA>(){

            public DATA fromCommand(ParticleType<DATA> particleType, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                double blastRadius = reader.readDouble();
                reader.expect(' ');
                String eventStr = reader.readString();
                SoundEvent soundEvent = CBCRegistryUtils.getSoundEvent(CBCUtils.location(eventStr));
                if (soundEvent == null) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
                }
                reader.expect(' ');
                String sourceStr = reader.readString();
                SoundSource soundSource = CBCUtils.soundSourceFromName(sourceStr);
                if (soundSource == null) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
                }
                reader.expect(' ');
                float volume = reader.readFloat();
                reader.expect(' ');
                float pitch = reader.readFloat();
                reader.expect(' ');
                float airAbsorption = reader.readFloat();
                reader.expect(' ');
                float power = reader.readFloat();
                return (AbstractBlastWaveEffectParticleData)cons.apply(blastRadius, BuiltInRegistries.f_256894_.m_263177_((Object)soundEvent), soundSource, Float.valueOf(volume), Float.valueOf(pitch), Float.valueOf(airAbsorption), Float.valueOf(power));
            }

            public DATA fromNetwork(ParticleType<DATA> particleType, FriendlyByteBuf buffer) {
                double blastRadius = buffer.readDouble();
                SoundEvent soundEvent = CBCRegistryUtils.getSoundEvent(buffer.m_130242_());
                SoundSource soundSource = (SoundSource)buffer.m_130066_(SoundSource.class);
                float volume = buffer.readFloat();
                float pitch = buffer.readFloat();
                float airAbsorption = buffer.readFloat();
                float power = buffer.readFloat();
                return (AbstractBlastWaveEffectParticleData)cons.apply(blastRadius, BuiltInRegistries.f_256894_.m_263177_((Object)soundEvent), soundSource, Float.valueOf(volume), Float.valueOf(pitch), Float.valueOf(airAbsorption), Float.valueOf(power));
            }
        };
    }

    protected static <DATA extends AbstractBlastWaveEffectParticleData<DATA>> Codec<DATA> createCodec(Constructor<DATA> cons) {
        return RecordCodecBuilder.create(i -> i.group((App)Codec.DOUBLE.fieldOf("blastRadius").forGetter(AbstractBlastWaveEffectParticleData::blastRadius), (App)SoundEvent.f_263130_.fieldOf("soundEvent").forGetter(AbstractBlastWaveEffectParticleData::soundEvent), (App)CBCUtils.SOUND_SOURCE_CODEC.fieldOf("soundSource").forGetter(AbstractBlastWaveEffectParticleData::soundSource), (App)Codec.FLOAT.fieldOf("volume").forGetter(AbstractBlastWaveEffectParticleData::volume), (App)Codec.FLOAT.fieldOf("pitch").forGetter(AbstractBlastWaveEffectParticleData::pitch), (App)Codec.FLOAT.fieldOf("airAbsorption").forGetter(AbstractBlastWaveEffectParticleData::airAbsorption), (App)Codec.FLOAT.fieldOf("power").forGetter(AbstractBlastWaveEffectParticleData::power)).apply((Applicative)i, (Function7)cons));
    }

    protected AbstractBlastWaveEffectParticleData(double blastRadius, Holder<SoundEvent> soundEvent, SoundSource soundSource, float volume, float pitch, float airAbsorption, float power) {
        this.blastRadius = blastRadius;
        this.soundEvent = soundEvent;
        this.soundSource = soundSource;
        this.volume = volume;
        this.pitch = pitch;
        this.airAbsorption = airAbsorption;
        this.power = power;
    }

    protected AbstractBlastWaveEffectParticleData() {
        this(0.0, (Holder<SoundEvent>)BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11913_), SoundSource.BLOCKS, 1.0f, 1.0f, 0.0f, 0.0f);
    }

    public double blastRadius() {
        return this.blastRadius;
    }

    public Holder<SoundEvent> soundEvent() {
        return this.soundEvent;
    }

    public SoundSource soundSource() {
        return this.soundSource;
    }

    public float volume() {
        return this.volume;
    }

    public float pitch() {
        return this.pitch;
    }

    public float airAbsorption() {
        return this.airAbsorption;
    }

    public float power() {
        return this.power;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.blastRadius);
        buffer.m_130130_(CBCRegistryUtils.getSoundEventNumericId((SoundEvent)this.soundEvent.m_203334_())).m_130068_((Enum)this.soundSource).writeFloat(this.volume).writeFloat(this.pitch).writeFloat(this.airAbsorption).writeFloat(this.power);
    }

    public String m_5942_() {
        return String.format("%f %s %s %f %f %f %f", this.blastRadius, CBCRegistryUtils.getSoundEventLocation((SoundEvent)this.soundEvent.m_203334_()).toString(), this.soundSource.m_12676_(), Float.valueOf(this.volume), Float.valueOf(this.pitch), Float.valueOf(this.airAbsorption), Float.valueOf(this.power));
    }

    public static interface Constructor<DATA extends AbstractBlastWaveEffectParticleData<DATA>>
    extends Function7<Double, Holder<SoundEvent>, SoundSource, Float, Float, Float, Float, DATA> {
    }
}

