/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.forge;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.MissingMappingsEvent;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCItems;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

@Mod.EventBusSubscriber(modid="createbigcannons", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CBCRemapperForge {
    private static final Map<String, ResourceLocation> REMAP = new HashMap<String, ResourceLocation>();

    @SubscribeEvent
    public static void onRemapItem(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(event.getKey(), "createbigcannons")) {
            Item remapped;
            ResourceLocation key = mapping.getKey();
            String path = key.m_135815_();
            ResourceLocation remapLoc = REMAP.get(path);
            if (remapLoc == null || (remapped = CBCRegistryUtils.getItem(remapLoc)) == null) continue;
            CreateBigCannons.LOGGER.warn("Remapping item '{}' to '{}'", (Object)key, (Object)remapLoc);
            try {
                mapping.remap((Object)remapped);
            }
            catch (Throwable t) {
                CreateBigCannons.LOGGER.warn("Remapping item '{}' to '{}' failed: {}", (Object)key, (Object)remapLoc, (Object)t);
            }
        }
    }

    @SubscribeEvent
    public static void onRemapBlock(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(event.getKey(), "createbigcannons")) {
            Block remapped;
            ResourceLocation key = mapping.getKey();
            String path = key.m_135815_();
            ResourceLocation remapLoc = REMAP.get(path);
            if (remapLoc == null || (remapped = CBCRegistryUtils.getBlock(remapLoc)) == null) continue;
            CreateBigCannons.LOGGER.warn("Remapping block '{}' to '{}'", (Object)key, (Object)remapLoc);
            try {
                mapping.remap((Object)remapped);
            }
            catch (Throwable t) {
                CreateBigCannons.LOGGER.warn("Remapping block '{}' to '{}' failed: {}", (Object)key, (Object)remapLoc, (Object)t);
            }
        }
    }

    static {
        REMAP.put("cannon_cast_wand", CBCItems.CANNON_CRAFTING_WAND.getId());
        REMAP.put("nether_gunmetal_cannon_barrel", CBCBlocks.NETHERSTEEL_CANNON_BARREL.getId());
        REMAP.put("nether_gunmetal_cannon_chamber", CBCBlocks.NETHERSTEEL_CANNON_CHAMBER.getId());
        REMAP.put("nether_gunmetal_screw_breech", CBCBlocks.NETHERSTEEL_SCREW_BREECH.getId());
        REMAP.put("unbored_sliding_breech_cast_mould", CBCBlocks.SLIDING_BREECH_CAST_MOULD.getId());
    }
}

