/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Vector3f;

public class ElectrotineOreBlock
extends DropExperienceBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final DustParticleOptions ELECTROTINE_PARTICLE = new DustParticleOptions(new Vector3f(0.05882353f, 0.40392157f, 0.69803923f), 0.6f);

    public ElectrotineOreBlock(BlockBehaviour.Properties properties, IntProvider xpRange) {
        super(properties.m_60953_(s -> (Boolean)s.m_61143_((Property)LIT) != false ? 9 : 0), xpRange);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        ElectrotineOreBlock.interact(state, world, pos);
        super.m_6256_(state, world, pos, player);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity player) {
        ElectrotineOreBlock.interact(world.m_8055_(pos), world, pos);
        super.m_141947_(world, pos, state, player);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (world.f_46443_) {
            ElectrotineOreBlock.spawnParticles(world, pos);
        } else {
            ElectrotineOreBlock.interact(state, world, pos);
        }
        ItemStack itemstack = player.m_21120_(hand);
        return itemstack.m_41720_() instanceof BlockItem && new BlockPlaceContext(player, hand, itemstack, rayTraceResult).m_7059_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    private static void interact(BlockState state, Level world, BlockPos pos) {
        ElectrotineOreBlock.spawnParticles(world, pos);
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            ElectrotineOreBlock.spawnParticles(world, pos);
        }
    }

    private static void spawnParticles(Level world, BlockPos pos) {
        double d0 = 0.5625;
        RandomSource random = world.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.m_121945_(direction);
            if (world.m_8055_(blockpos).m_60804_((BlockGetter)world, blockpos)) continue;
            Direction.Axis axis = direction.m_122434_();
            double d1 = axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)random.m_188501_();
            double d2 = axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)random.m_188501_();
            double d3 = axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)random.m_188501_();
            world.m_7106_((ParticleOptions)ELECTROTINE_PARTICLE, (double)pos.m_123341_() + d1, (double)pos.m_123342_() + d2, (double)pos.m_123343_() + d3, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{LIT});
    }
}

