/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.plugin.jei;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe;

public class RetexturableRecipeExtension
implements ICraftingCategoryExtension {
    private final ShapedRetexturedRecipe recipe;
    private final List<ItemStack> displayOutputs;
    private final int[] textureSlots;

    RetexturableRecipeExtension(ShapedRetexturedRecipe recipe) {
        this.recipe = recipe;
        Ingredient texture = recipe.getTexture();
        RegistryAccess access = Objects.requireNonNull(SafeClientAccess.getRegistryAccess());
        List<ItemStack> displayOutputs = Arrays.stream(texture.m_43908_()).map(stack -> recipe.getResultItem(stack.m_41720_(), access)).toList();
        this.displayOutputs = displayOutputs.isEmpty() ? List.of(this.recipe.m_8043_(access)) : displayOutputs;
        NonNullList inputs = recipe.m_7527_();
        this.textureSlots = IntStream.range(0, inputs.size()).filter(arg_0 -> RetexturableRecipeExtension.lambda$new$1(texture, (List)inputs, arg_0)).toArray();
    }

    private static boolean ingredientsMatch(Ingredient left, Ingredient right) {
        ItemStack[] rightStacks;
        ItemStack[] leftStacks = left.m_43908_();
        if (leftStacks.length != (rightStacks = right.m_43908_()).length) {
            return false;
        }
        for (int i = 0; i < leftStacks.length; ++i) {
            if (ItemStack.m_150942_((ItemStack)leftStacks[i], (ItemStack)rightStacks[i])) continue;
            return false;
        }
        return true;
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.m_6423_();
    }

    public int getWidth() {
        return this.recipe.getRecipeWidth();
    }

    public int getHeight() {
        return this.recipe.getRecipeHeight();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(this.recipe.m_8043_(Objects.requireNonNull(SafeClientAccess.getRegistryAccess())));
        List<List> inputStacks = this.recipe.m_7527_().stream().map(ingredient -> List.of(ingredient.m_43908_())).toList();
        int width = this.recipe.m_44220_();
        int height = this.recipe.m_44221_();
        List inputs = craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputStacks, this.recipe.m_44220_(), this.recipe.m_44221_());
        IRecipeSlotBuilder output = craftingGridHelper.createAndSetOutputs(builder, this.displayOutputs);
        if (inputs.size() != 9) {
            Mantle.logger.error("Failed to create focus link for {} as the layout {} is not 3x3", (Object)this.recipe.m_6423_(), (Object)builder.getClass().getName());
        } else {
            builder.createFocusLink((IIngredientAcceptor[])Streams.concat((Stream[])new Stream[]{Stream.of(output), Arrays.stream(this.textureSlots).mapToObj(i -> (IRecipeSlotBuilder)inputs.get(RetexturableRecipeExtension.getCraftingIndex(i, width, height)))}).toArray(IRecipeSlotBuilder[]::new));
        }
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    private static /* synthetic */ boolean lambda$new$1(Ingredient texture, List inputs, int i) {
        return RetexturableRecipeExtension.ingredientsMatch(texture, (Ingredient)inputs.get(i));
    }
}

