/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import li.cil.oc2.common.util.TranslationUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileChooserScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MARGIN = 30;
    private static final int WIDGET_SPACING = 8;
    private static final int TEXT_FIELD_HEIGHT = 20;
    private static final int BUTTON_HEIGHT = 20;
    private static final int LIST_ENTRY_HEIGHT = 12;
    private static final Component OPEN_TITLE_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.title.load");
    private static final Component SAVE_TITLE_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.title.save");
    private static final Component FILE_NAME_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.text_field.filename");
    private static final Component LOAD_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.confirm_button.load");
    private static final Component SAVE_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.confirm_button.save");
    private static final Component OVERWRITE_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.confirm_button.overwrite");
    private static final Component CANCEL_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.cancel_button");
    private static Path directory = Paths.get("", new String[0]).toAbsolutePath();
    private final FileChooserCallback callback;
    private final boolean isLoad;
    private final Screen previousScreen;
    private FileList fileList;
    private EditBox fileNameTextField;
    private Button okButton;
    private boolean isComplete;

    public static void openFileChooserForSave(String name, FileChooserCallback callback) {
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof FileChooserScreen) {
            currentScreen.m_7379_();
        }
        FileChooserScreen screen = new FileChooserScreen(callback, false);
        Minecraft.m_91087_().m_91152_((Screen)screen);
        screen.fileNameTextField.m_94144_(name);
    }

    public static void openFileChooserForLoad(FileChooserCallback callback) {
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof FileChooserScreen) {
            currentScreen.m_7379_();
        }
        FileChooserScreen screen = new FileChooserScreen(callback, true);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    public FileChooserScreen(FileChooserCallback callback, boolean isLoad) {
        super(isLoad ? OPEN_TITLE_TEXT : SAVE_TITLE_TEXT);
        this.callback = callback;
        this.isLoad = isLoad;
        this.previousScreen = Minecraft.m_91087_().f_91080_;
    }

    public void m_7379_() {
        if (!this.isComplete) {
            this.callback.onCanceled();
        }
        if (this.previousScreen != null) {
            this.getMinecraft().m_6937_(() -> this.getMinecraft().m_91152_(this.previousScreen));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_280273_(graphics);
        this.fileList.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.fileNameTextField.m_88315_(graphics, mouseX, mouseY, partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        int widgetsWidth = this.f_96543_ - 60;
        int listHeight = this.f_96544_ - 30 - 8 - 20 - 8 - 20 - 30;
        this.fileList = new FileList(30, listHeight, 12);
        this.m_7787_((GuiEventListener)this.fileList);
        int fileNameTop = 30 + listHeight + 8;
        this.fileNameTextField = new EditBox(this.f_96547_, 30, fileNameTop, widgetsWidth, 20, FILE_NAME_TEXT);
        this.fileNameTextField.m_94151_(s -> {
            this.fileList.setSelected(null);
            this.updateButtons();
        });
        this.fileNameTextField.m_94199_(1024);
        this.m_7787_((GuiEventListener)this.fileNameTextField);
        int buttonTop = fileNameTop + 20 + 8;
        int buttonCount = 2;
        int buttonWidth = widgetsWidth / 2 - 8;
        this.okButton = (Button)this.m_142416_((GuiEventListener)new Button(30, buttonTop, buttonWidth, 20, (Component)Component.m_237119_(), this::handleOkPressed, Supplier::get));
        this.m_142416_((GuiEventListener)new Button(30 + buttonWidth + 8, buttonTop, buttonWidth, 20, CANCEL_TEXT, this::handleCancelPressed, Supplier::get));
        this.fileList.refreshFiles(directory);
        this.updateButtons();
    }

    public void m_7400_(List<Path> files) {
        files.stream().filter(file -> {
            try {
                return Files.exists(file, new LinkOption[0]) && !Files.isHidden(file);
            }
            catch (IOException | SecurityException ignored) {
                return false;
            }
        }).findFirst().ifPresent(this.fileList::selectPath);
    }

    private boolean isParentPath() {
        if (directory == null) {
            return false;
        }
        FileList.FileEntry selected = (FileList.FileEntry)this.fileList.m_93511_();
        if (selected != null) {
            return Objects.equals(selected.file, directory.getParent());
        }
        String selectedFileEntry = this.fileNameTextField.m_94155_();
        return "..".equals(selectedFileEntry);
    }

    private Optional<Path> getPath() {
        FileList.FileEntry selected = (FileList.FileEntry)this.fileList.m_93511_();
        if (selected != null) {
            return Optional.ofNullable(selected.file);
        }
        if (directory == null) {
            return Optional.empty();
        }
        String selectedFileEntry = this.fileNameTextField.m_94155_();
        if (selectedFileEntry.isEmpty() || ".".equals(selectedFileEntry)) {
            return Optional.empty();
        }
        try {
            return Optional.of(directory.resolve(selectedFileEntry));
        }
        catch (InvalidPathException e) {
            return Optional.empty();
        }
    }

    private void confirm() {
        if (this.isParentPath()) {
            this.fileList.refreshFiles(this.getPath().orElse(null));
            return;
        }
        this.getPath().ifPresent(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.fileList.refreshFiles((Path)path);
                return;
            }
            if (Files.isRegularFile(path, new LinkOption[0])) {
                this.isComplete = true;
                this.callback.onFileSelected((Path)path);
                this.m_7379_();
            } else if (!this.isLoad) {
                this.isComplete = true;
                this.callback.onFileSelected((Path)path);
                this.m_7379_();
            }
        });
    }

    private void cancel() {
        this.isComplete = true;
        this.callback.onCanceled();
        this.m_7379_();
    }

    private void updateButtons() {
        this.okButton.f_93623_ = false;
        this.okButton.m_93666_(this.isLoad ? LOAD_TEXT : SAVE_TEXT);
        this.okButton.clearFGColor();
        if (this.isParentPath()) {
            this.okButton.f_93623_ = true;
            return;
        }
        this.getPath().ifPresent(path -> {
            if (this.isLoad) {
                this.okButton.f_93623_ = Files.exists(path, new LinkOption[0]);
            } else {
                this.okButton.f_93623_ = true;
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    this.okButton.m_93666_(OVERWRITE_TEXT);
                    this.okButton.setFGColor(0xFF0000);
                }
            }
        });
    }

    private void handleOkPressed(Button button) {
        this.confirm();
    }

    private void handleCancelPressed(Button button) {
        this.cancel();
    }

    @FunctionalInterface
    public static interface FileChooserCallback {
        public void onFileSelected(Path var1);

        default public void onCanceled() {
        }
    }

    private final class FileList
    extends ObjectSelectionList<FileEntry> {
        public FileList(int y, int height, int slotHeight) {
            super(FileChooserScreen.this.getMinecraft(), FileChooserScreen.this.f_96543_, FileChooserScreen.this.f_96544_, y, y + height, slotHeight);
        }

        public void refreshFiles(@Nullable Path directory) {
            FileChooserScreen.directory = directory;
            this.m_93410_(0.0);
            this.m_93516_();
            if (directory != null && Files.isDirectory(directory, new LinkOption[0])) {
                this.m_7085_((AbstractSelectionList.Entry)this.createDirectoryEntry(directory.getParent(), ".."));
                try {
                    List<Path> files = Files.list(directory).sorted((p1, p2) -> {
                        if (Files.isDirectory(p1, new LinkOption[0]) && !Files.isDirectory(p2, new LinkOption[0])) {
                            return -1;
                        }
                        if (!Files.isDirectory(p1, new LinkOption[0]) && Files.isDirectory(p2, new LinkOption[0])) {
                            return 1;
                        }
                        return p1.getFileName().compareTo(p2.getFileName());
                    }).toList();
                    for (Path path : files) {
                        try {
                            if (Files.isHidden(path)) continue;
                            if (Files.isDirectory(path, new LinkOption[0])) {
                                this.m_7085_((AbstractSelectionList.Entry)this.createDirectoryEntry(path));
                                continue;
                            }
                            this.m_7085_((AbstractSelectionList.Entry)this.createFileEntry(path));
                        }
                        catch (IOException | SecurityException exception) {}
                    }
                }
                catch (IOException | SecurityException e) {
                    LOGGER.error((Object)e);
                }
            } else {
                for (Path path : FileSystems.getDefault().getRootDirectories()) {
                    this.m_7085_((AbstractSelectionList.Entry)this.createDirectoryEntry(path, path.toString()));
                }
            }
            FileChooserScreen.this.fileNameTextField.m_94144_("");
        }

        public void selectPath(Path path) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.refreshFiles(path);
            } else {
                this.refreshFiles(path.getParent());
                this.m_6702_().stream().filter(entry -> path.equals(entry.file)).findFirst().ifPresent(entry -> {
                    entry.select();
                    this.m_93494_((AbstractSelectionList.Entry)entry);
                });
            }
        }

        public void setSelected(@Nullable FileEntry entry) {
            super.m_6987_((AbstractSelectionList.Entry)entry);
            FileChooserScreen.this.updateButtons();
        }

        private FileEntry createFileEntry(Path file) {
            return new FileEntry(file, (Component)Component.m_237113_((String)file.getFileName().toString()));
        }

        private FileEntry createDirectoryEntry(Path path) {
            return this.createDirectoryEntry(path, path.getFileName().toString() + path.getFileSystem().getSeparator());
        }

        private FileEntry createDirectoryEntry(@Nullable Path path, String displayName) {
            TextColor color = path != null && Files.exists(path, new LinkOption[0]) ? TextColor.m_131266_((int)0xA0A0FF) : TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY);
            return new FileEntry(path, (Component)Component.m_237113_((String)displayName).m_130938_(s -> s.m_131148_(color)));
        }

        private final class FileEntry
        extends ObjectSelectionList.Entry<FileEntry> {
            @Nullable
            private final Path file;
            private final Component displayName;
            private long lastEntryClickTime = 0L;

            public FileEntry(Path file, Component displayName) {
                this.file = file;
                this.displayName = displayName;
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float deltaTime) {
                this.drawShadow(FileChooserScreen.this.f_96547_, graphics, this.displayName, left, top, -1);
            }

            private void drawShadow(Font font, GuiGraphics graphics, Component text, float x, float y, int color) {
                MultiBufferSource.BufferSource batch = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                font.m_272077_(text, x, y, color, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)batch, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                batch.m_109911_();
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                boolean isLeftClick;
                boolean bl = isLeftClick = button == 0;
                if (isLeftClick) {
                    boolean isDoubleClick;
                    this.select();
                    boolean bl2 = isDoubleClick = System.currentTimeMillis() - this.lastEntryClickTime < 250L;
                    if (isDoubleClick && FileChooserScreen.this.okButton.f_93623_) {
                        FileChooserScreen.this.confirm();
                    }
                    this.lastEntryClickTime = System.currentTimeMillis();
                }
                return false;
            }

            public void select() {
                if (directory != null && Objects.equals(directory.getParent(), this.file)) {
                    FileChooserScreen.this.fileNameTextField.m_94144_("..");
                } else if (this.file != null) {
                    Path fileName = this.file.getFileName();
                    FileChooserScreen.this.fileNameTextField.m_94144_(fileName != null ? fileName.toString() : this.file.toString());
                } else {
                    return;
                }
                FileChooserScreen.this.fileNameTextField.m_94198_();
                FileChooserScreen.this.fileNameTextField.m_94208_(0);
                FileList.this.setSelected(this);
            }

            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.displayName});
            }
        }
    }
}

