/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.BlockDeviceBusElement;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.provider.BlockDeviceProvider;
import li.cil.oc2.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2.api.util.Invalidatable;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.AbstractGroupingDeviceBusElement;
import li.cil.oc2.common.bus.device.provider.Providers;
import li.cil.oc2.common.bus.device.rpc.TypeNameRPCDevice;
import li.cil.oc2.common.bus.device.util.BlockDeviceInfo;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.util.LevelUtils;
import li.cil.oc2.common.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class AbstractBlockDeviceBusElement
extends AbstractGroupingDeviceBusElement<BlockEntry, BlockDeviceQuery>
implements BlockDeviceBusElement {
    public AbstractBlockDeviceBusElement() {
        super(Constants.BLOCK_FACE_COUNT);
    }

    @Override
    public Optional<Collection<LazyOptional<DeviceBusElement>>> getNeighbors() {
        LevelAccessor level = this.getLevel();
        if (level == null || level.m_5776_()) {
            return Optional.empty();
        }
        ArrayList<LazyOptional> neighbors = new ArrayList<LazyOptional>();
        for (Direction neighborDirection : Constants.DIRECTIONS) {
            LazyOptional capability;
            if (!this.canScanContinueTowards(neighborDirection)) continue;
            BlockPos neighborPos = this.getPosition().m_121945_(neighborDirection);
            ChunkPos chunkPos = new ChunkPos(neighborPos);
            if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
                return Optional.empty();
            }
            BlockEntity blockEntity = level.m_7702_(neighborPos);
            if (blockEntity == null || !(capability = blockEntity.getCapability(Capabilities.deviceBusElement(), neighborDirection.m_122424_())).isPresent()) continue;
            neighbors.add(capability);
        }
        return Optional.of(neighbors);
    }

    public void updateDevicesForNeighbor(Direction side) {
        LevelAccessor level = this.getLevel();
        if (level == null || level.m_5776_()) {
            return;
        }
        int index = side.m_122411_();
        this.collectDevices(level, this.getPosition().m_121945_(side), side).ifPresentOrElse(queryResult -> this.setEntriesForGroup(index, (AbstractGroupingDeviceBusElement.QueryResult)queryResult), () -> this.setEntriesForGroupUnloaded(index));
    }

    public void setRemoved() {
        LevelAccessor level = this.getLevel();
        if (level == null || level.m_5776_()) {
            return;
        }
        for (Direction side : Direction.values()) {
            int index = side.m_122411_();
            BlockPos pos = this.getPosition().m_121945_(side);
            BlockDeviceQuery query = Devices.makeQuery(level, pos, side.m_122424_());
            this.setEntriesForGroup(index, new BlockQueryResult(query, Collections.emptySet()));
        }
        this.scheduleScan();
    }

    protected boolean canScanContinueTowards(@Nullable Direction direction) {
        return true;
    }

    protected boolean canDetectDevicesTowards(@Nullable Direction direction) {
        return this.canScanContinueTowards(direction);
    }

    protected Optional<BlockQueryResult> collectDevices(LevelAccessor level, BlockPos pos, @Nullable Direction side) {
        BlockDeviceQuery query = Devices.makeQuery(level, pos, side != null ? side.m_122424_() : null);
        HashSet<BlockEntry> entries = new HashSet<BlockEntry>();
        if (this.canDetectDevicesTowards(side)) {
            Optional<List<Invalidatable<BlockDeviceInfo>>> loadedDevices = Devices.getDevices(query);
            if (loadedDevices.isPresent()) {
                for (Invalidatable<BlockDeviceInfo> deviceInfo : loadedDevices.get()) {
                    if (!deviceInfo.isPresent()) continue;
                    entries.add(new BlockEntry(deviceInfo, side));
                }
            } else {
                return Optional.empty();
            }
            this.collectSyntheticDevices(level, pos, side, entries);
        }
        return Optional.of(new BlockQueryResult(query, entries));
    }

    protected void collectSyntheticDevices(LevelAccessor level, BlockPos pos, @Nullable Direction side, HashSet<BlockEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        String blockName = LevelUtils.getBlockName(level, pos);
        if (blockName != null) {
            entries.add(new BlockEntry(new BlockDeviceInfo(null, new TypeNameRPCDevice(blockName)), side));
        }
    }

    @Override
    protected void onEntryAdded(BlockEntry entry) {
        super.onEntryAdded(entry);
        entry.addListener();
    }

    @Override
    protected void onEntryRemoved(BlockEntry entry) {
        super.onEntryRemoved(entry);
        entry.removeListener();
    }

    @Override
    protected void onEntryRemoved(String dataKey, CompoundTag tag, @Nullable BlockDeviceQuery query) {
        super.onEntryRemoved(dataKey, tag, query);
        assert (query != null) : "Passed null query for block device bus element.";
        IForgeRegistry<BlockDeviceProvider> registry = Providers.blockDeviceProviderRegistry();
        BlockDeviceProvider provider = (BlockDeviceProvider)registry.getValue(ResourceLocation.parse((String)dataKey));
        if (provider != null) {
            provider.unmount(query, tag);
        }
    }

    protected final class BlockQueryResult
    extends AbstractGroupingDeviceBusElement.QueryResult {
        private final BlockDeviceQuery query;
        private final Set<BlockEntry> entries;

        public BlockQueryResult(BlockDeviceQuery query, Set<BlockEntry> entries) {
            super(AbstractBlockDeviceBusElement.this);
            this.query = query;
            this.entries = entries;
        }

        public BlockDeviceQuery getQuery() {
            return this.query;
        }

        public Set<BlockEntry> getEntries() {
            return this.entries;
        }
    }

    protected final class BlockEntry
    implements AbstractGroupingDeviceBusElement.Entry {
        private final Invalidatable<BlockDeviceInfo> deviceInfo;
        @Nullable
        private final String dataKey;
        private final Device device;
        @Nullable
        private final Direction side;
        private Invalidatable.ListenerToken token;

        public BlockEntry(@Nullable Invalidatable<BlockDeviceInfo> deviceInfo, Direction side) {
            this.deviceInfo = deviceInfo;
            this.side = side;
            this.dataKey = RegistryUtils.optionalKey((BlockDeviceProvider)deviceInfo.get().provider).orElse(null);
            this.device = deviceInfo.get().device;
        }

        public BlockEntry(@Nullable BlockDeviceInfo deviceInfo, Direction side) {
            this(Invalidatable.of(deviceInfo), side);
        }

        @Override
        public Optional<String> getDeviceDataKey() {
            return Optional.ofNullable(this.dataKey);
        }

        @Override
        public OptionalInt getDeviceEnergyConsumption() {
            return this.deviceInfo.isPresent() ? OptionalInt.of(this.deviceInfo.get().getEnergyConsumption()) : OptionalInt.empty();
        }

        @Override
        public Device getDevice() {
            return this.device;
        }

        public void addListener() {
            if (this.token == null && this.side != null) {
                this.token = this.deviceInfo.addListener(unused -> AbstractBlockDeviceBusElement.this.updateDevicesForNeighbor(this.side));
            }
        }

        public void removeListener() {
            if (this.token != null) {
                this.token.removeListener();
                this.token = null;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockEntry that = (BlockEntry)o;
            return Objects.equals(this.dataKey, that.dataKey) && this.device.equals(that.device) && this.side == that.side;
        }

        public int hashCode() {
            return Objects.hash(this.dataKey, this.device, this.side);
        }

        public String toString() {
            return this.device.toString();
        }
    }
}

