/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.common.bus.AbstractDeviceBusElement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public abstract class AbstractGroupingDeviceBusElement<TEntry extends Entry, TQuery>
extends AbstractDeviceBusElement {
    private static final String GROUPS_TAG_NAME = "groups";
    private static final String GROUP_ID_TAG_NAME = "groupId";
    private static final String GROUP_DATA_TAG_NAME = "groupData";
    protected final int groupCount;
    protected final ArrayList<HashSet<TEntry>> groups;
    protected final UUID[] groupIds;
    protected final CompoundTag[] groupData;

    protected AbstractGroupingDeviceBusElement(int groupCount) {
        this.groupCount = groupCount;
        this.groups = new ArrayList(groupCount);
        this.groupIds = new UUID[groupCount];
        this.groupData = new CompoundTag[groupCount];
        for (int i = 0; i < groupCount; ++i) {
            this.groups.add(new HashSet());
            this.groupIds[i] = UUID.randomUUID();
            this.groupData[i] = new CompoundTag();
        }
    }

    public CompoundTag save() {
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.groupCount; ++i) {
            this.saveGroup(i);
            CompoundTag sideTag = new CompoundTag();
            sideTag.m_128362_(GROUP_ID_TAG_NAME, this.groupIds[i]);
            sideTag.m_128365_(GROUP_DATA_TAG_NAME, (Tag)this.groupData[i]);
            listTag.add((Object)sideTag);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(GROUPS_TAG_NAME, (Tag)listTag);
        return tag;
    }

    public void load(CompoundTag tag) {
        ListTag listTag = tag.m_128437_(GROUPS_TAG_NAME, 10);
        int count = Math.min(this.groupCount, listTag.size());
        for (int i = 0; i < count; ++i) {
            CompoundTag sideTag = listTag.m_128728_(i);
            if (sideTag.m_128403_(GROUP_ID_TAG_NAME)) {
                this.groupIds[i] = sideTag.m_128342_(GROUP_ID_TAG_NAME);
            }
            if (sideTag.m_128425_(GROUP_DATA_TAG_NAME, 10)) {
                this.groupData[i] = sideTag.m_128469_(GROUP_DATA_TAG_NAME);
            }
            for (Entry entry : this.groups.get(i)) {
                CompoundTag devicesTag = this.groupData[i];
                entry.getDeviceDataKey().ifPresent(key -> {
                    if (devicesTag.m_128425_(key, 10)) {
                        entry.getDevice().deserializeNBT(devicesTag.m_128469_(key));
                    }
                });
            }
        }
    }

    @Override
    public Optional<UUID> getDeviceIdentifier(Device device) {
        for (int i = 0; i < this.groupCount; ++i) {
            HashSet<TEntry> group = this.groups.get(i);
            for (Entry deviceInfo : group) {
                if (!Objects.equals(device, deviceInfo.getDevice())) continue;
                return Optional.of(this.groupIds[i]);
            }
        }
        return super.getDeviceIdentifier(device);
    }

    protected final void setEntriesForGroupUnloaded(int index) {
        HashSet<TEntry> oldEntries = this.groups.get(index);
        if (oldEntries.isEmpty()) {
            return;
        }
        this.saveGroup(index);
        for (Entry entry : oldEntries) {
            this.devices.removeInt((Object)entry.getDevice());
            this.onEntryRemoved(entry);
        }
        oldEntries.clear();
        this.scanDevices();
    }

    protected final void setEntriesForGroup(int index, QueryResult queryResult) {
        HashSet<TEntry> entries;
        Set newEntries = queryResult.getEntries();
        if (Objects.equals(newEntries, entries = this.groups.get(index))) {
            CompoundTag devicesTag;
            if (entries.isEmpty() && !(devicesTag = this.groupData[index]).m_128456_()) {
                Iterator iterator = devicesTag.m_128431_().iterator();
                while (iterator.hasNext()) {
                    String dataKey = (String)iterator.next();
                    if (devicesTag.m_128425_(dataKey, 10)) {
                        CompoundTag tag = devicesTag.m_128469_(dataKey);
                        this.onEntryRemoved(dataKey, tag, queryResult.getQuery());
                    }
                    iterator.remove();
                }
            }
            return;
        }
        boolean hadOldEntries = !entries.isEmpty();
        HashSet<TEntry> removedEntries = new HashSet<TEntry>(entries);
        removedEntries.removeAll(newEntries);
        for (Object entry : removedEntries) {
            this.devices.removeInt((Object)entry.getDevice());
            this.onEntryRemoved(entry);
        }
        HashSet addedEntries = new HashSet(newEntries);
        addedEntries.removeAll(entries);
        for (Object entry : addedEntries) {
            this.devices.put((Object)entry.getDevice(), entry.getDeviceEnergyConsumption().orElse(0));
            this.onEntryAdded(entry);
        }
        entries.removeAll(removedEntries);
        entries.addAll(newEntries);
        CompoundTag devicesTag = this.groupData[index];
        for (Object entry : removedEntries) {
            entry.getDeviceDataKey().ifPresent(arg_0 -> ((CompoundTag)devicesTag).m_128473_(arg_0));
        }
        HashSet invalidDataKeys = new HashSet(devicesTag.m_128431_());
        for (Entry entry : addedEntries) {
            entry.getDeviceDataKey().ifPresent(key -> {
                invalidDataKeys.remove(key);
                if (devicesTag.m_128425_(key, 10)) {
                    entry.getDevice().deserializeNBT(devicesTag.m_128469_(key));
                } else {
                    devicesTag.m_128473_(key);
                }
            });
        }
        Object query = queryResult.getQuery();
        for (String invalidDataKey : invalidDataKeys) {
            if (devicesTag.m_128425_(invalidDataKey, 10)) {
                CompoundTag tag = devicesTag.m_128469_(invalidDataKey);
                this.onEntryRemoved(invalidDataKey, tag, query);
            }
            devicesTag.m_128473_(invalidDataKey);
        }
        if (hadOldEntries) {
            this.groupIds[index] = UUID.randomUUID();
        }
        this.scanDevices();
        for (Entry entry : removedEntries) {
            entry.getDevice().dispose();
        }
    }

    protected void onEntryAdded(TEntry entry) {
    }

    protected void onEntryRemoved(TEntry entry) {
    }

    protected void onEntryRemoved(String dataKey, CompoundTag data, @Nullable TQuery query) {
    }

    private void saveGroup(int index) {
        CompoundTag devicesTag = new CompoundTag();
        for (Entry entry : this.groups.get(index)) {
            entry.getDeviceDataKey().ifPresent(key -> devicesTag.m_128365_(key, (Tag)entry.getDevice().serializeNBT()));
        }
        this.groupData[index] = devicesTag;
    }

    protected static interface Entry {
        public Optional<String> getDeviceDataKey();

        public OptionalInt getDeviceEnergyConsumption();

        public Device getDevice();
    }

    protected abstract class QueryResult {
        protected QueryResult() {
        }

        @Nullable
        public abstract TQuery getQuery();

        public abstract Set<TEntry> getEntries();
    }
}

