/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.data;

import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.data.Firmware;
import li.cil.oc2.api.util.Registries;
import li.cil.oc2.common.bus.device.data.MinuxFirmware;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public final class FirmwareRegistry {
    private static final DeferredRegister<Firmware> INITIALIZER = DeferredRegister.create(Registries.FIRMWARE, (String)"oc2r");
    private static final Supplier<IForgeRegistry<Firmware>> REGISTRY = INITIALIZER.makeRegistry(RegistryBuilder::new);
    public static final RegistryObject<Firmware> MINUX = INITIALIZER.register("minux", MinuxFirmware::new);

    public static void initialize(FMLJavaModLoadingContext context) {
        INITIALIZER.register(context.getModEventBus());
    }

    public static ResourceLocation getKey(Firmware firmware) {
        return INITIALIZER.getRegistryName();
    }

    @Nullable
    public static Firmware getValue(ResourceLocation location) {
        return (Firmware)REGISTRY.get().getValue(location);
    }

    public static Stream<Firmware> values() {
        return REGISTRY.get().getValues().stream();
    }
}

