/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.rpc;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public final class RPCItemStackTagFilter {
    public ResourceLocation item;
    public String[] tags;
    private String[][] paths;

    @Nullable
    public CompoundTag apply(ItemStack stack, CompoundTag tag) {
        if (stack.m_41619_() || this.tags == null) {
            return null;
        }
        if (this.item != null && !Objects.equals(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), this.item)) {
            return null;
        }
        this.validatePaths();
        CompoundTag filtered = new CompoundTag();
        for (String[] path : this.paths) {
            CompoundTag filteredByPath = this.filterPath(path, tag);
            if (filteredByPath == null) continue;
            filtered.m_128391_(filteredByPath);
        }
        return filtered;
    }

    @Nullable
    private CompoundTag filterPath(String[] path, CompoundTag source) {
        if (path.length == 0) {
            return null;
        }
        CompoundTag result = new CompoundTag();
        CompoundTag currentSource = source;
        CompoundTag currentTarget = result;
        for (int j = 0; j < path.length - 1; ++j) {
            String segment = path[j];
            if (!currentSource.m_128425_(segment, 10)) {
                return null;
            }
            currentSource = currentSource.m_128469_(segment);
            currentTarget.m_128365_(segment, (Tag)new CompoundTag());
            currentTarget = currentTarget.m_128469_(segment);
        }
        Tag tag = currentSource.m_128423_(path[path.length - 1]);
        if (tag == null) {
            return null;
        }
        currentTarget.m_128365_(path[path.length - 1], tag);
        return result;
    }

    private void validatePaths() {
        this.paths = new String[this.tags.length][];
        for (int i = 0; i < this.tags.length; ++i) {
            if (StringUtil.m_14408_((String)this.tags[i])) continue;
            this.paths[i] = this.tags[i].split("\\.");
        }
    }
}

