/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.rpc.item;

import java.time.Duration;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.api.capabilities.Robot;
import li.cil.oc2.api.util.RobotOperationSide;
import li.cil.oc2.common.bus.device.rpc.item.AbstractItemRPCDevice;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.util.FakePlayerUtils;
import li.cil.oc2.common.util.TickUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public final class BlockOperationsModuleDevice
extends AbstractItemRPCDevice {
    private static final String LAST_OPERATION_TAG_NAME = "cooldown";
    private static final int COOLDOWN = TickUtils.toTicks(Duration.ofSeconds(1L));
    private final Entity entity;
    private final Robot robot;
    private long lastOperation;

    public BlockOperationsModuleDevice(ItemStack identity, Entity entity, Robot robot) {
        super(identity, "block_operations");
        this.entity = entity;
        this.robot = robot;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_(LAST_OPERATION_TAG_NAME, this.lastOperation);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.lastOperation = (long)Mth.m_14036_((float)tag.m_128454_(LAST_OPERATION_TAG_NAME), (float)0.0f, (float)this.entity.m_9236_().m_46467_());
    }

    @Callback
    public boolean excavate() {
        return this.excavate(null);
    }

    @Callback
    public boolean excavate(@Parameter(value="side") @Nullable RobotOperationSide side) {
        if (this.isOnCooldown()) {
            return false;
        }
        this.beginCooldown();
        Level level = this.entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStackHandler inventory = this.robot.getInventory();
        List<ItemEntity> oldItems = this.getItemsInRange();
        Direction direction = RobotOperationSide.toGlobal(this.entity, side);
        if (!this.tryHarvestBlock(serverLevel, this.entity.m_20183_().m_121945_(direction))) {
            return false;
        }
        List<ItemEntity> droppedItems = this.getItemsInRange();
        droppedItems.removeAll(oldItems);
        for (ItemEntity itemEntity : droppedItems) {
            ItemStack stack = itemEntity.m_32055_();
            stack = this.insertStartingAt((IItemHandler)inventory, stack, selectedSlot, false);
            itemEntity.m_32045_(stack);
        }
        return true;
    }

    @Callback
    public boolean place() {
        return this.place(null);
    }

    @Callback
    public boolean place(@Parameter(value="side") @Nullable RobotOperationSide side) {
        Item item;
        if (this.isOnCooldown()) {
            return false;
        }
        this.beginCooldown();
        Level level = this.entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStackHandler inventory = this.robot.getInventory();
        ItemStack extracted = inventory.extractItem(selectedSlot, 1, true);
        if (extracted.m_41619_() || !((item = extracted.m_41720_()) instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Direction direction = RobotOperationSide.toGlobal(this.entity, side);
        BlockPos blockPos = this.entity.m_20183_().m_121945_(direction);
        Direction oppositeDirection = direction.m_122424_();
        BlockHitResult hit = new BlockHitResult(Vec3.m_82512_((Vec3i)blockPos).m_82549_(Vec3.m_82512_((Vec3i)oppositeDirection.m_122436_()).m_82490_(0.5)), oppositeDirection, blockPos, false);
        ItemStack itemStack = extracted.m_41777_();
        ServerPlayer player = FakePlayerUtils.getFakePlayer(serverLevel, this.entity);
        BlockPlaceContext context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, itemStack, hit);
        InteractionResult result = blockItem.m_40576_(context);
        if (!result.m_19077_()) {
            return false;
        }
        if (itemStack.m_41619_()) {
            inventory.extractItem(selectedSlot, 1, false);
        }
        return true;
    }

    @Callback(synchronize=false)
    public int durability() {
        return ((ItemStack)this.identity).m_41776_() - ((ItemStack)this.identity).m_41773_();
    }

    @Callback
    public boolean repair() {
        if (this.isOnCooldown()) {
            return false;
        }
        this.beginCooldown();
        if (((ItemStack)this.identity).m_41773_() == 0) {
            return false;
        }
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStackHandler inventory = this.robot.getInventory();
        ItemStack extracted = inventory.extractItem(selectedSlot, 1, true);
        Tier tier = this.getRepairItemTier(extracted);
        if (tier == null) {
            return false;
        }
        int repairValue = tier.m_6609_();
        if (repairValue == 0) {
            return false;
        }
        if (inventory.extractItem(selectedSlot, 1, false).m_41619_()) {
            return false;
        }
        ((ItemStack)this.identity).m_41721_(((ItemStack)this.identity).m_41773_() - repairValue);
        return true;
    }

    private void beginCooldown() {
        this.lastOperation = this.entity.m_9236_().m_46467_();
    }

    private boolean isOnCooldown() {
        return this.entity.m_9236_().m_46467_() - this.lastOperation < (long)COOLDOWN;
    }

    private List<ItemEntity> getItemsInRange() {
        return this.entity.m_9236_().m_45976_(ItemEntity.class, this.entity.m_20191_().m_82400_(2.0));
    }

    private boolean tryHarvestBlock(ServerLevel level, BlockPos blockPos) {
        boolean isCommandBlock;
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState.m_60795_()) {
            return false;
        }
        ServerPlayer player = FakePlayerUtils.getFakePlayer(level, this.entity);
        int experience = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)GameType.f_151492_, (ServerPlayer)player, (BlockPos)blockPos);
        if (experience == -1) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        Block block = blockState.m_60734_();
        boolean bl = isCommandBlock = block instanceof CommandBlock || block instanceof StructureBlock || block instanceof JigsawBlock;
        if (isCommandBlock && !player.m_36337_()) {
            return false;
        }
        if (player.m_36187_((Level)level, blockPos, GameType.f_151492_)) {
            return false;
        }
        Tier toolTier = TierSortingRegistry.byName((ResourceLocation)Config.blockOperationsModuleToolTier);
        if (toolTier == null || !TierSortingRegistry.isCorrectTierForDrops((Tier)toolTier, (BlockState)blockState)) {
            return false;
        }
        if (!ForgeEventFactory.doPlayerHarvestCheck((Player)player, (BlockState)blockState, (boolean)true)) {
            return false;
        }
        if (((ItemStack)this.identity).m_220157_(1, level.f_46441_, null)) {
            return false;
        }
        if (!blockState.onDestroyedByPlayer((Level)level, blockPos, (Player)player, true, level.m_6425_(blockPos))) {
            return false;
        }
        block.m_6786_((LevelAccessor)level, blockPos, blockState);
        block.m_6240_((Level)level, (Player)player, blockPos, blockState, blockEntity, ItemStack.f_41583_);
        return true;
    }

    @Nullable
    private Tier getRepairItemTier(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            return tieredItem.m_43314_();
        }
        return null;
    }

    private ItemStack insertStartingAt(IItemHandler handler, ItemStack stack, int startSlot, boolean simulate) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            int slot = (startSlot + i) % handler.getSlots();
            stack = handler.insertItem(slot, stack, simulate);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }
}

