/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.rpc.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.DocumentedDevice;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.api.capabilities.RedstoneEmitter;
import li.cil.oc2.api.util.Side;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.device.rpc.item.AbstractItemRPCDevice;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.util.HorizontalBlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public final class RedstoneInterfaceCardItemDevice
extends AbstractItemRPCDevice
implements DocumentedDevice,
ICapabilityProvider {
    private static final String OUTPUT_TAG_NAME = "output";
    private static final String GET_REDSTONE_INPUT = "getRedstoneInput";
    private static final String GET_REDSTONE_OUTPUT = "getRedstoneOutput";
    private static final String SET_REDSTONE_OUTPUT = "setRedstoneOutput";
    private static final String SIDE = "side";
    private static final String VALUE = "value";
    private final BlockEntity blockEntity;
    private final RedstoneEmitter[] capabilities;
    private final byte[] output = new byte[Constants.BLOCK_FACE_COUNT];

    public RedstoneInterfaceCardItemDevice(ItemStack identity, BlockEntity blockEntity) {
        super(identity, "redstone");
        this.blockEntity = blockEntity;
        this.capabilities = new RedstoneEmitter[Constants.BLOCK_FACE_COUNT];
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            int indexForClosure = i;
            this.capabilities[i] = () -> this.output[indexForClosure];
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == Capabilities.redstoneEmitter() && side != null) {
            int index = side.m_122411_();
            return LazyOptional.of(() -> this.capabilities[index]).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128382_(OUTPUT_TAG_NAME, this.output);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        byte[] serializedOutput = tag.m_128463_(OUTPUT_TAG_NAME);
        System.arraycopy(serializedOutput, 0, this.output, 0, Math.min(serializedOutput.length, this.output.length));
    }

    @Callback(name="getRedstoneInput")
    public int getRedstoneInput(@Parameter(value="side") @Nullable Side side) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        Level level = this.blockEntity.m_58904_();
        if (level == null) {
            return 0;
        }
        BlockPos pos = this.blockEntity.m_58899_();
        Direction direction = HorizontalBlockUtils.toGlobal(this.blockEntity.m_58900_(), side);
        assert (direction != null);
        BlockPos neighborPos = pos.m_121945_(direction);
        ChunkPos chunkPos = new ChunkPos(neighborPos);
        if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            return 0;
        }
        return level.m_277185_(neighborPos, direction);
    }

    @Callback(name="getRedstoneOutput", synchronize=false)
    public int getRedstoneOutput(@Parameter(value="side") @Nullable Side side) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        int index = side.getDirection().m_122411_();
        return this.output[index];
    }

    @Callback(name="setRedstoneOutput")
    public void setRedstoneOutput(@Parameter(value="side") @Nullable Side side, @Parameter(value="value") int value) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        int index = side.getDirection().m_122411_();
        byte clampedValue = (byte)Mth.m_14045_((int)value, (int)0, (int)15);
        if (clampedValue == this.output[index]) {
            return;
        }
        this.output[index] = clampedValue;
        Direction direction = HorizontalBlockUtils.toGlobal(this.blockEntity.m_58900_(), side);
        if (direction != null) {
            this.notifyNeighbor(direction);
        }
    }

    @Override
    public void getDeviceDocumentation(DocumentedDevice.DeviceVisitor visitor) {
        visitor.visitCallback(GET_REDSTONE_INPUT).description("Get the current redstone level received on the specified side. Note that if the current output level on the specified side is not zero, this will affect the measured level.\nSides may be specified by name or zero-based index. Please note that the side depends on the orientation of the device's container.").returnValueDescription("the current received level on the specified side.").parameterDescription(SIDE, "the side to read the input level from.");
        visitor.visitCallback(GET_REDSTONE_OUTPUT).description("Get the current redstone level transmitted on the specified side. This will return the value last set via setRedstoneOutput().\nSides may be specified by name or zero-based index. Please note that the side depends on the orientation of the device's container.").returnValueDescription("the current transmitted level on the specified side.").parameterDescription(SIDE, "the side to read the output level from.");
        visitor.visitCallback(SET_REDSTONE_OUTPUT).description("Set the new redstone level transmitted on the specified side.\nSides may be specified by name or zero-based index. Please note that the side depends on the orientation of the device's container.").parameterDescription(SIDE, "the side to write the output level to.").parameterDescription(VALUE, "the output level to set, will be clamped to [0, 15].");
    }

    private void notifyNeighbor(Direction direction) {
        Level level = this.blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        level.m_46672_(this.blockEntity.m_58899_(), this.blockEntity.m_58900_().m_60734_());
        level.m_46672_(this.blockEntity.m_58899_().m_121945_(direction), this.blockEntity.m_58900_().m_60734_());
    }
}

