/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.vm.block;

import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.common.bus.device.util.IdentityProxy;
import li.cil.oc2.common.bus.device.util.OptionalAddress;
import li.cil.oc2.common.bus.device.util.OptionalInterrupt;
import li.cil.oc2.common.serialization.NBTSerialization;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.device.virtio.VirtIOKeyboardDevice;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public final class KeyboardDevice<T>
extends IdentityProxy<T>
implements VMDevice {
    private static final String DEVICE_TAG_NAME = "device";
    private static final String ADDRESS_TAG_NAME = "address";
    private static final String INTERRUPT_TAG_NAME = "interrupt";
    @Nullable
    private VirtIOKeyboardDevice device;
    private final OptionalAddress address = new OptionalAddress();
    private final OptionalInterrupt interrupt = new OptionalInterrupt();
    private CompoundTag deviceTag;

    public KeyboardDevice(T identity) {
        super(identity);
    }

    public void sendKeyEvent(int keycode, boolean isDown) {
        if (this.device != null) {
            this.device.sendKeyEvent(keycode, isDown);
        }
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        if (!this.allocateDevice(context)) {
            return VMDeviceLoadResult.fail();
        }
        assert (this.device != null);
        if (!this.address.claim(context, (MemoryMappedDevice)this.device)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.interrupt.claim(context)) {
            return VMDeviceLoadResult.fail();
        }
        this.device.getInterrupt().set(this.interrupt.getAsInt(), context.getInterruptController());
        context.getEventBus().register(this);
        if (this.deviceTag != null) {
            NBTSerialization.deserialize(this.deviceTag, this.device);
        }
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.device = null;
    }

    @Override
    public void dispose() {
        this.deviceTag = null;
        this.address.clear();
        this.interrupt.clear();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.device != null) {
            this.deviceTag = NBTSerialization.serialize(this.device);
        }
        if (this.deviceTag != null) {
            tag.m_128365_(DEVICE_TAG_NAME, (Tag)this.deviceTag);
        }
        if (this.address.isPresent()) {
            tag.m_128356_(ADDRESS_TAG_NAME, this.address.getAsLong());
        }
        if (this.interrupt.isPresent()) {
            tag.m_128405_(INTERRUPT_TAG_NAME, this.interrupt.getAsInt());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_(DEVICE_TAG_NAME, 10)) {
            this.deviceTag = tag.m_128469_(DEVICE_TAG_NAME);
        }
        if (tag.m_128425_(ADDRESS_TAG_NAME, 4)) {
            this.address.set(tag.m_128454_(ADDRESS_TAG_NAME));
        }
        if (tag.m_128425_(INTERRUPT_TAG_NAME, 3)) {
            this.interrupt.set(tag.m_128451_(INTERRUPT_TAG_NAME));
        }
    }

    private boolean allocateDevice(VMContext context) {
        if (!context.getMemoryAllocator().claimMemory(4096)) {
            return false;
        }
        this.device = new VirtIOKeyboardDevice(context.getMemoryMap());
        return true;
    }
}

